/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.transport;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.teleal.cling.UpnpServiceConfiguration;
import org.teleal.cling.model.NetworkAddress;
import org.teleal.cling.model.message.IncomingDatagramMessage;
import org.teleal.cling.model.message.OutgoingDatagramMessage;
import org.teleal.cling.model.message.StreamRequestMessage;
import org.teleal.cling.model.message.StreamResponseMessage;
import org.teleal.cling.protocol.ProtocolFactory;
import org.teleal.cling.transport.Router;
import org.teleal.cling.transport.SwitchableRouter;
import org.teleal.cling.transport.spi.InitializationException;
import org.teleal.cling.transport.spi.NetworkAddressFactory;
import org.teleal.cling.transport.spi.UpnpStream;
import org.teleal.common.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchableRouterImpl
implements SwitchableRouter {
    private static final Logger log = Logger.getLogger(Router.class.getName());
    private final UpnpServiceConfiguration configuration;
    private final ProtocolFactory protocolFactory;
    private Router router;
    protected ReentrantReadWriteLock routerLock = new ReentrantReadWriteLock(true);
    protected Lock readLock = this.routerLock.readLock();
    protected Lock writeLock = this.routerLock.writeLock();

    public SwitchableRouterImpl(UpnpServiceConfiguration configuration, ProtocolFactory protocolFactory) {
        this.configuration = configuration;
        this.protocolFactory = protocolFactory;
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnabled() throws RouterLockAcquisitionException {
        this.lock(this.readLock);
        try {
            boolean bl = this.router != null;
            return bl;
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean enable() throws RouterLockAcquisitionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void handleStartFailure(InitializationException ex) {
        log.severe("Unable to initialize network router: " + ex);
        log.severe("Cause: " + Exceptions.unwrap(ex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disable() throws RouterLockAcquisitionException {
        this.lock(this.writeLock);
        try {
            if (this.router != null) {
                log.fine("Disabling network transport router");
                this.router.shutdown();
                this.router = null;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock(this.writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkAddressFactory getNetworkAddressFactory() throws RouterLockAcquisitionException {
        this.lock(this.readLock);
        try {
            NetworkAddressFactory networkAddressFactory = this.router != null ? this.router.getNetworkAddressFactory() : new DisabledNetworkAddressFactory();
            return networkAddressFactory;
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NetworkAddress> getActiveStreamServers(InetAddress preferredAddress) throws RouterLockAcquisitionException {
        this.lock(this.readLock);
        try {
            List<NetworkAddress> list = this.router != null ? this.router.getActiveStreamServers(preferredAddress) : Collections.EMPTY_LIST;
            return list;
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    @Override
    public void shutdown() throws RouterLockAcquisitionException {
        this.disable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void received(IncomingDatagramMessage msg) throws RouterLockAcquisitionException {
        this.lock(this.readLock);
        try {
            if (this.router != null) {
                this.router.received(msg);
            }
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void received(UpnpStream stream) throws RouterLockAcquisitionException {
        this.lock(this.readLock);
        try {
            if (this.router != null) {
                this.router.received(stream);
            }
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(OutgoingDatagramMessage msg) throws RouterLockAcquisitionException {
        this.lock(this.readLock);
        try {
            if (this.router != null) {
                this.router.send(msg);
            }
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamResponseMessage send(StreamRequestMessage msg) throws RouterLockAcquisitionException {
        this.lock(this.readLock);
        try {
            StreamResponseMessage streamResponseMessage = this.router != null ? this.router.send(msg) : null;
            return streamResponseMessage;
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcast(byte[] bytes) throws RouterLockAcquisitionException {
        this.lock(this.readLock);
        try {
            if (this.router != null) {
                this.router.broadcast(bytes);
            }
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    protected void lock(Lock lock, int timeoutMilliseconds) throws RouterLockAcquisitionException {
        try {
            log.finest("Trying to obtain lock with timeout milliseconds '" + timeoutMilliseconds + "': " + lock.getClass().getSimpleName());
            if (!lock.tryLock(timeoutMilliseconds, TimeUnit.MILLISECONDS)) {
                throw new RouterLockAcquisitionException("Failed to acquire router lock: " + lock.getClass().getSimpleName());
            }
            log.finest("Acquired router lock: " + lock.getClass().getSimpleName());
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to acquire router lock: " + lock.getClass().getSimpleName(), e);
        }
    }

    protected void lock(Lock lock) throws RouterLockAcquisitionException {
        this.lock(lock, this.getLockTimeoutMillis());
    }

    protected void unlock(Lock lock) {
        log.finest("Releasing router lock: " + lock.getClass().getSimpleName());
        lock.unlock();
    }

    protected int getLockTimeoutMillis() {
        return 6000;
    }

    public static class RouterLockAcquisitionException
    extends RuntimeException {
        public RouterLockAcquisitionException() {
        }

        public RouterLockAcquisitionException(String s) {
            super(s);
        }

        public RouterLockAcquisitionException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public RouterLockAcquisitionException(Throwable throwable) {
            super(throwable);
        }
    }

    class DisabledNetworkAddressFactory
    implements NetworkAddressFactory {
        DisabledNetworkAddressFactory() {
        }

        public InetAddress getMulticastGroup() {
            return null;
        }

        public int getMulticastPort() {
            return 0;
        }

        public int getStreamListenPort() {
            return 0;
        }

        public NetworkInterface[] getNetworkInterfaces() {
            return new NetworkInterface[0];
        }

        public InetAddress[] getBindAddresses() {
            return new InetAddress[0];
        }

        public byte[] getHardwareAddress(InetAddress inetAddress) {
            return new byte[0];
        }

        public InetAddress getBroadcastAddress(InetAddress inetAddress) {
            return null;
        }

        public InetAddress getLocalAddress(NetworkInterface networkInterface, boolean isIPv6, InetAddress remoteAddress) throws IllegalStateException {
            return null;
        }
    }
}

