/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.transport;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.teleal.cling.UpnpServiceConfiguration;
import org.teleal.cling.model.NetworkAddress;
import org.teleal.cling.model.message.IncomingDatagramMessage;
import org.teleal.cling.model.message.OutgoingDatagramMessage;
import org.teleal.cling.model.message.StreamRequestMessage;
import org.teleal.cling.model.message.StreamResponseMessage;
import org.teleal.cling.protocol.ProtocolCreationException;
import org.teleal.cling.protocol.ProtocolFactory;
import org.teleal.cling.protocol.ReceivingAsync;
import org.teleal.cling.transport.Router;
import org.teleal.cling.transport.spi.DatagramIO;
import org.teleal.cling.transport.spi.InitializationException;
import org.teleal.cling.transport.spi.MulticastReceiver;
import org.teleal.cling.transport.spi.NetworkAddressFactory;
import org.teleal.cling.transport.spi.StreamClient;
import org.teleal.cling.transport.spi.StreamServer;
import org.teleal.cling.transport.spi.UpnpStream;
import org.teleal.common.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterImpl
implements Router {
    private static Logger log = Logger.getLogger(Router.class.getName());
    protected final UpnpServiceConfiguration configuration;
    protected final ProtocolFactory protocolFactory;
    protected final StreamClient streamClient;
    protected final NetworkAddressFactory networkAddressFactory;
    protected final Map<NetworkInterface, MulticastReceiver> multicastReceivers = new HashMap<NetworkInterface, MulticastReceiver>();
    protected final Map<InetAddress, DatagramIO> datagramIOs = new HashMap<InetAddress, DatagramIO>();
    protected final Map<InetAddress, StreamServer> streamServers = new HashMap<InetAddress, StreamServer>();

    public RouterImpl(UpnpServiceConfiguration configuration, ProtocolFactory protocolFactory) throws InitializationException {
        log.info("Creating Router: " + this.getClass().getName());
        this.configuration = configuration;
        this.protocolFactory = protocolFactory;
        log.fine("Starting networking services...");
        this.networkAddressFactory = this.getConfiguration().createNetworkAddressFactory();
        this.streamClient = this.getConfiguration().createStreamClient();
        for (NetworkInterface networkInterface : this.networkAddressFactory.getNetworkInterfaces()) {
            MulticastReceiver multicastReceiver = this.getConfiguration().createMulticastReceiver(this.networkAddressFactory);
            if (multicastReceiver == null) continue;
            this.multicastReceivers.put(networkInterface, multicastReceiver);
        }
        for (InetAddress inetAddress : this.networkAddressFactory.getBindAddresses()) {
            StreamServer streamServer;
            DatagramIO datagramIO = this.getConfiguration().createDatagramIO(this.networkAddressFactory);
            if (datagramIO != null) {
                this.datagramIOs.put(inetAddress, datagramIO);
            }
            if ((streamServer = this.getConfiguration().createStreamServer(this.networkAddressFactory)) == null) continue;
            this.streamServers.put(inetAddress, streamServer);
        }
        for (Map.Entry<InetAddress, StreamServer> entry : this.streamServers.entrySet()) {
            log.fine("Starting stream server on address: " + entry.getKey());
            entry.getValue().init(entry.getKey(), this);
            this.getConfiguration().getStreamServerExecutor().execute(entry.getValue());
        }
        for (Map.Entry<Object, Runnable> entry : this.multicastReceivers.entrySet()) {
            log.fine("Starting multicast receiver on interface: " + ((NetworkInterface)entry.getKey()).getDisplayName());
            ((MulticastReceiver)entry.getValue()).init((NetworkInterface)entry.getKey(), this, this.getConfiguration().getDatagramProcessor());
            this.getConfiguration().getMulticastReceiverExecutor().execute(entry.getValue());
        }
        for (Map.Entry<Object, Runnable> entry : this.datagramIOs.entrySet()) {
            log.fine("Starting datagram I/O on address: " + entry.getKey());
            ((DatagramIO)entry.getValue()).init((InetAddress)entry.getKey(), this, this.getConfiguration().getDatagramProcessor());
            this.getConfiguration().getDatagramIOExecutor().execute(entry.getValue());
        }
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    @Override
    public NetworkAddressFactory getNetworkAddressFactory() {
        return this.networkAddressFactory;
    }

    protected Map<NetworkInterface, MulticastReceiver> getMulticastReceivers() {
        return this.multicastReceivers;
    }

    protected Map<InetAddress, DatagramIO> getDatagramIOs() {
        return this.datagramIOs;
    }

    protected StreamClient getStreamClient() {
        return this.streamClient;
    }

    protected Map<InetAddress, StreamServer> getStreamServers() {
        return this.streamServers;
    }

    @Override
    public synchronized List<NetworkAddress> getActiveStreamServers(InetAddress preferredAddress) {
        StreamServer preferredServer;
        if (this.getStreamServers().size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<NetworkAddress> streamServerAddresses = new ArrayList<NetworkAddress>();
        if (preferredAddress != null && (preferredServer = this.getStreamServers().get(preferredAddress)) != null) {
            streamServerAddresses.add(new NetworkAddress(preferredAddress, preferredServer.getPort(), this.getNetworkAddressFactory().getHardwareAddress(preferredAddress)));
            return streamServerAddresses;
        }
        for (Map.Entry<InetAddress, StreamServer> entry : this.getStreamServers().entrySet()) {
            byte[] hardwareAddress = this.getNetworkAddressFactory().getHardwareAddress(entry.getKey());
            streamServerAddresses.add(new NetworkAddress(entry.getKey(), entry.getValue().getPort(), hardwareAddress));
        }
        return streamServerAddresses;
    }

    @Override
    public synchronized void shutdown() {
        log.fine("Shutting down network services");
        if (this.streamClient != null) {
            log.fine("Stopping stream client connection management/pool");
            this.streamClient.stop();
        }
        for (Map.Entry<InetAddress, StreamServer> entry : this.streamServers.entrySet()) {
            log.fine("Stopping stream server on address: " + entry.getKey());
            entry.getValue().stop();
        }
        this.streamServers.clear();
        for (Map.Entry<Object, Runnable> entry : this.multicastReceivers.entrySet()) {
            log.fine("Stopping multicast receiver on interface: " + ((NetworkInterface)entry.getKey()).getDisplayName());
            ((MulticastReceiver)entry.getValue()).stop();
        }
        this.multicastReceivers.clear();
        for (Map.Entry<Object, Runnable> entry : this.datagramIOs.entrySet()) {
            log.fine("Stopping datagram I/O on address: " + entry.getKey());
            ((DatagramIO)entry.getValue()).stop();
        }
        this.datagramIOs.clear();
    }

    @Override
    public void received(IncomingDatagramMessage msg) {
        try {
            ReceivingAsync protocol = this.getProtocolFactory().createReceivingAsync(msg);
            if (protocol == null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("No protocol, ignoring received message: " + msg);
                }
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Received asynchronous message: " + msg);
            }
            this.getConfiguration().getAsyncProtocolExecutor().execute(protocol);
        }
        catch (ProtocolCreationException ex) {
            log.warning("Handling received datagram failed - " + Exceptions.unwrap(ex).toString());
        }
    }

    @Override
    public void received(UpnpStream stream) {
        log.fine("Received synchronous stream: " + stream);
        this.getConfiguration().getSyncProtocolExecutor().execute(stream);
    }

    @Override
    public void send(OutgoingDatagramMessage msg) {
        for (DatagramIO datagramIO : this.getDatagramIOs().values()) {
            datagramIO.send(msg);
        }
    }

    @Override
    public StreamResponseMessage send(StreamRequestMessage msg) {
        if (this.getStreamClient() == null) {
            log.fine("No StreamClient available, ignoring: " + msg);
            return null;
        }
        log.fine("Sending via TCP unicast stream: " + msg);
        return this.getStreamClient().sendRequest(msg);
    }

    @Override
    public void broadcast(byte[] bytes) {
        for (Map.Entry<InetAddress, DatagramIO> entry : this.getDatagramIOs().entrySet()) {
            InetAddress broadcast = this.getNetworkAddressFactory().getBroadcastAddress(entry.getKey());
            if (broadcast == null) continue;
            log.fine("Sending UDP datagram to broadcast address: " + broadcast.getHostAddress());
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length, broadcast, 9);
            entry.getValue().send(packet);
        }
    }
}

