/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.registry;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.teleal.cling.UpnpService;
import org.teleal.cling.UpnpServiceConfiguration;
import org.teleal.cling.model.ServiceReference;
import org.teleal.cling.model.gena.LocalGENASubscription;
import org.teleal.cling.model.gena.RemoteGENASubscription;
import org.teleal.cling.model.meta.Device;
import org.teleal.cling.model.meta.LocalDevice;
import org.teleal.cling.model.meta.RemoteDevice;
import org.teleal.cling.model.meta.RemoteDeviceIdentity;
import org.teleal.cling.model.meta.Service;
import org.teleal.cling.model.resource.Resource;
import org.teleal.cling.model.types.DeviceType;
import org.teleal.cling.model.types.ServiceType;
import org.teleal.cling.model.types.UDN;
import org.teleal.cling.protocol.ProtocolFactory;
import org.teleal.cling.registry.LocalItems;
import org.teleal.cling.registry.Registry;
import org.teleal.cling.registry.RegistryItem;
import org.teleal.cling.registry.RegistryListener;
import org.teleal.cling.registry.RegistryMaintainer;
import org.teleal.cling.registry.RemoteItems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryImpl
implements Registry {
    private static Logger log = Logger.getLogger(Registry.class.getName());
    protected final UpnpService upnpService;
    protected RegistryMaintainer registryMaintainer;
    protected ReentrantLock remoteSubscriptionsLock = new ReentrantLock(true);
    protected final Set<RegistryListener> registryListeners = new HashSet<RegistryListener>();
    protected final Set<RegistryItem<URI, Resource>> resourceItems = new HashSet<RegistryItem<URI, Resource>>();
    protected final List<Runnable> pendingExecutions = new ArrayList<Runnable>();
    protected final RemoteItems remoteItems = new RemoteItems(this);
    protected final LocalItems localItems = new LocalItems(this);

    public RegistryImpl(UpnpService upnpService) {
        log.fine("Creating Registry: " + this.getClass().getName());
        this.upnpService = upnpService;
        log.fine("Starting registry background maintenance...");
        this.registryMaintainer = this.createRegistryMaintainer();
        if (this.registryMaintainer != null) {
            this.getConfiguration().getRegistryMaintainerExecutor().execute(this.registryMaintainer);
        }
    }

    @Override
    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.getUpnpService().getConfiguration();
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.getUpnpService().getProtocolFactory();
    }

    protected RegistryMaintainer createRegistryMaintainer() {
        return new RegistryMaintainer(this, this.getConfiguration().getRegistryMaintenanceIntervalMillis());
    }

    @Override
    public synchronized void addListener(RegistryListener listener) {
        this.registryListeners.add(listener);
    }

    @Override
    public synchronized void removeListener(RegistryListener listener) {
        this.registryListeners.remove(listener);
    }

    @Override
    public synchronized Collection<RegistryListener> getListeners() {
        return Collections.unmodifiableCollection(this.registryListeners);
    }

    @Override
    public synchronized boolean notifyDiscoveryStart(final RemoteDevice device) {
        if (this.getUpnpService().getRegistry().getRemoteDevice(((RemoteDeviceIdentity)device.getIdentity()).getUdn(), true) != null) {
            log.finer("Not notifying listeners, already registered: " + device);
            return false;
        }
        for (final RegistryListener listener : this.getListeners()) {
            this.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                public void run() {
                    listener.remoteDeviceDiscoveryStarted(RegistryImpl.this, device);
                }
            });
        }
        return true;
    }

    @Override
    public synchronized void notifyDiscoveryFailure(final RemoteDevice device, final Exception ex) {
        for (final RegistryListener listener : this.getListeners()) {
            this.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                public void run() {
                    listener.remoteDeviceDiscoveryFailed(RegistryImpl.this, device, ex);
                }
            });
        }
    }

    @Override
    public synchronized void addDevice(LocalDevice localDevice) {
        this.localItems.add(localDevice);
    }

    @Override
    public synchronized void addDevice(RemoteDevice remoteDevice) {
        this.remoteItems.add(remoteDevice);
    }

    @Override
    public synchronized boolean update(RemoteDeviceIdentity rdIdentity) {
        return this.remoteItems.update(rdIdentity);
    }

    @Override
    public synchronized boolean removeDevice(LocalDevice localDevice) {
        return this.localItems.remove(localDevice);
    }

    @Override
    public synchronized boolean removeDevice(RemoteDevice remoteDevice) {
        return this.remoteItems.remove(remoteDevice);
    }

    @Override
    public synchronized void removeAllLocalDevices() {
        this.localItems.removeAll();
    }

    @Override
    public synchronized void removeAllRemoteDevices() {
        this.remoteItems.removeAll();
    }

    @Override
    public synchronized boolean removeDevice(UDN udn) {
        Device device = this.getDevice(udn, true);
        if (device != null && device instanceof LocalDevice) {
            return this.removeDevice((LocalDevice)device);
        }
        if (device != null && device instanceof RemoteDevice) {
            return this.removeDevice((RemoteDevice)device);
        }
        return false;
    }

    @Override
    public synchronized Device getDevice(UDN udn, boolean rootOnly) {
        Object device = this.localItems.get(udn, rootOnly);
        if (device != null) {
            return device;
        }
        device = this.remoteItems.get(udn, rootOnly);
        if (device != null) {
            return device;
        }
        return null;
    }

    @Override
    public synchronized LocalDevice getLocalDevice(UDN udn, boolean rootOnly) {
        return (LocalDevice)this.localItems.get(udn, rootOnly);
    }

    @Override
    public synchronized RemoteDevice getRemoteDevice(UDN udn, boolean rootOnly) {
        return (RemoteDevice)this.remoteItems.get(udn, rootOnly);
    }

    @Override
    public synchronized Collection<LocalDevice> getLocalDevices() {
        return Collections.unmodifiableCollection(this.localItems.get());
    }

    @Override
    public synchronized Collection<RemoteDevice> getRemoteDevices() {
        return Collections.unmodifiableCollection(this.remoteItems.get());
    }

    @Override
    public synchronized Collection<Device> getDevices() {
        HashSet<LocalDevice> all = new HashSet<LocalDevice>();
        all.addAll(this.localItems.get());
        all.addAll(this.remoteItems.get());
        return Collections.unmodifiableCollection(all);
    }

    @Override
    public synchronized Collection<Device> getDevices(DeviceType deviceType) {
        HashSet devices = new HashSet();
        devices.addAll(this.localItems.get(deviceType));
        devices.addAll(this.remoteItems.get(deviceType));
        return Collections.unmodifiableCollection(devices);
    }

    @Override
    public synchronized Collection<Device> getDevices(ServiceType serviceType) {
        HashSet devices = new HashSet();
        devices.addAll(this.localItems.get(serviceType));
        devices.addAll(this.remoteItems.get(serviceType));
        return Collections.unmodifiableCollection(devices);
    }

    @Override
    public synchronized Service getService(ServiceReference serviceReference) {
        Device device = this.getDevice(serviceReference.getUdn(), false);
        if (device != null) {
            return device.findService(serviceReference.getServiceId());
        }
        return null;
    }

    @Override
    public synchronized Resource getResource(URI pathQuery) throws IllegalArgumentException {
        if (pathQuery.isAbsolute()) {
            throw new IllegalArgumentException("Resource URI can not be absolute, only path and query:" + pathQuery);
        }
        for (RegistryItem<URI, Resource> resourceItem : this.resourceItems) {
            Resource resource = resourceItem.getItem();
            if (!resource.matches(pathQuery)) continue;
            return resource;
        }
        if (pathQuery.getPath().endsWith("/")) {
            URI pathQueryWithoutSlash = URI.create(pathQuery.toString().substring(0, pathQuery.toString().length() - 1));
            for (RegistryItem<URI, Resource> resourceItem : this.resourceItems) {
                Resource resource = resourceItem.getItem();
                if (!resource.matches(pathQueryWithoutSlash)) continue;
                return resource;
            }
        }
        return null;
    }

    @Override
    public synchronized <T extends Resource> T getResource(Class<T> resourceType, URI pathQuery) throws IllegalArgumentException {
        Resource resource = this.getResource(pathQuery);
        if (resource != null && resourceType.isAssignableFrom(resource.getClass())) {
            return (T)resource;
        }
        return null;
    }

    @Override
    public synchronized Collection<Resource> getResources() {
        HashSet<Resource> s = new HashSet<Resource>();
        for (RegistryItem<URI, Resource> resourceItem : this.resourceItems) {
            s.add(resourceItem.getItem());
        }
        return s;
    }

    @Override
    public synchronized <T extends Resource> Collection<T> getResources(Class<T> resourceType) {
        HashSet<Resource> s = new HashSet<Resource>();
        for (RegistryItem<URI, Resource> resourceItem : this.resourceItems) {
            if (!resourceType.isAssignableFrom(resourceItem.getItem().getClass())) continue;
            s.add(resourceItem.getItem());
        }
        return s;
    }

    @Override
    public synchronized void addResource(Resource resource) {
        this.addResource(resource, 0);
    }

    @Override
    public synchronized void addResource(Resource resource, int maxAgeSeconds) {
        RegistryItem<URI, Resource> resourceItem = new RegistryItem<URI, Resource>(resource.getPathQuery(), resource, maxAgeSeconds);
        this.resourceItems.remove(resourceItem);
        this.resourceItems.add(resourceItem);
    }

    @Override
    public synchronized boolean removeResource(Resource resource) {
        return this.resourceItems.remove(new RegistryItem(resource.getPathQuery()));
    }

    @Override
    public synchronized void addLocalSubscription(LocalGENASubscription subscription) {
        this.localItems.addSubscription(subscription);
    }

    @Override
    public synchronized LocalGENASubscription getLocalSubscription(String subscriptionId) {
        return (LocalGENASubscription)this.localItems.getSubscription(subscriptionId);
    }

    @Override
    public synchronized boolean updateLocalSubscription(LocalGENASubscription subscription) {
        return this.localItems.updateSubscription(subscription);
    }

    @Override
    public synchronized boolean removeLocalSubscription(LocalGENASubscription subscription) {
        return this.localItems.removeSubscription(subscription);
    }

    @Override
    public synchronized void addRemoteSubscription(RemoteGENASubscription subscription) {
        this.remoteItems.addSubscription(subscription);
    }

    @Override
    public synchronized RemoteGENASubscription getRemoteSubscription(String subscriptionId) {
        return (RemoteGENASubscription)this.remoteItems.getSubscription(subscriptionId);
    }

    @Override
    public synchronized void updateRemoteSubscription(RemoteGENASubscription subscription) {
        this.remoteItems.updateSubscription(subscription);
    }

    @Override
    public synchronized void removeRemoteSubscription(RemoteGENASubscription subscription) {
        this.remoteItems.removeSubscription(subscription);
    }

    @Override
    public synchronized void shutdown() {
        RegistryItem[] resources;
        log.fine("Shutting down registry...");
        if (this.registryMaintainer != null) {
            this.registryMaintainer.stop();
        }
        log.finest("Executing final pending operations on shutdown: " + this.pendingExecutions.size());
        this.runPendingExecutions(false);
        for (RegistryListener listener : this.registryListeners) {
            listener.beforeShutdown(this);
        }
        for (RegistryItem resourceItem : resources = this.resourceItems.toArray(new RegistryItem[this.resourceItems.size()])) {
            ((Resource)resourceItem.getItem()).shutdown();
        }
        this.remoteItems.shutdown();
        this.localItems.shutdown();
        for (RegistryListener listener : this.registryListeners) {
            listener.afterShutdown();
        }
    }

    @Override
    public synchronized void pause() {
        if (this.registryMaintainer != null) {
            log.fine("Pausing registry maintenance");
            this.runPendingExecutions(true);
            this.registryMaintainer.stop();
            this.registryMaintainer = null;
        }
    }

    @Override
    public synchronized void resume() {
        if (this.registryMaintainer == null) {
            log.fine("Resuming registry maintenance");
            this.remoteItems.resume();
            this.registryMaintainer = this.createRegistryMaintainer();
            if (this.registryMaintainer != null) {
                this.getConfiguration().getRegistryMaintainerExecutor().execute(this.registryMaintainer);
            }
        }
    }

    @Override
    public synchronized boolean isPaused() {
        return this.registryMaintainer == null;
    }

    synchronized void maintain() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Maintaining registry...");
        }
        Iterator<RegistryItem<URI, Resource>> it = this.resourceItems.iterator();
        while (it.hasNext()) {
            RegistryItem<URI, Resource> item = it.next();
            if (!item.getExpirationDetails().hasExpired()) continue;
            if (log.isLoggable(Level.FINER)) {
                log.finer("Removing expired resource: " + item);
            }
            it.remove();
        }
        for (RegistryItem<URI, Resource> resourceItem : this.resourceItems) {
            resourceItem.getItem().maintain(this.pendingExecutions, resourceItem.getExpirationDetails());
        }
        this.remoteItems.maintain();
        this.localItems.maintain();
        this.runPendingExecutions(true);
    }

    synchronized void executeAsyncProtocol(Runnable runnable) {
        this.pendingExecutions.add(runnable);
    }

    synchronized void runPendingExecutions(boolean async) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Executing pending operations: " + this.pendingExecutions.size());
        }
        for (Runnable pendingExecution : this.pendingExecutions) {
            if (async) {
                this.getConfiguration().getAsyncProtocolExecutor().execute(pendingExecution);
                continue;
            }
            pendingExecution.run();
        }
        if (this.pendingExecutions.size() > 0) {
            this.pendingExecutions.clear();
        }
    }

    public void printDebugLog() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("====================================    REMOTE   ================================================");
            for (RemoteDevice remoteDevice : this.remoteItems.get()) {
                log.fine(remoteDevice.toString());
            }
            log.fine("====================================    LOCAL    ================================================");
            for (LocalDevice localDevice : this.localItems.get()) {
                log.fine(localDevice.toString());
            }
            log.fine("====================================  RESOURCES  ================================================");
            for (RegistryItem registryItem : this.resourceItems) {
                log.fine(registryItem.toString());
            }
            log.fine("=================================================================================================");
        }
    }

    @Override
    public void lockRemoteSubscriptions() {
        this.remoteSubscriptionsLock.lock();
    }

    @Override
    public void unlockRemoteSubscriptions() {
        this.remoteSubscriptionsLock.unlock();
    }
}

