/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.registry;

import java.net.URI;
import java.util.Collection;
import org.teleal.cling.UpnpService;
import org.teleal.cling.UpnpServiceConfiguration;
import org.teleal.cling.model.ServiceReference;
import org.teleal.cling.model.gena.LocalGENASubscription;
import org.teleal.cling.model.gena.RemoteGENASubscription;
import org.teleal.cling.model.meta.Device;
import org.teleal.cling.model.meta.LocalDevice;
import org.teleal.cling.model.meta.RemoteDevice;
import org.teleal.cling.model.meta.RemoteDeviceIdentity;
import org.teleal.cling.model.meta.Service;
import org.teleal.cling.model.resource.Resource;
import org.teleal.cling.model.types.DeviceType;
import org.teleal.cling.model.types.ServiceType;
import org.teleal.cling.model.types.UDN;
import org.teleal.cling.protocol.ProtocolFactory;
import org.teleal.cling.registry.RegistrationException;
import org.teleal.cling.registry.RegistryListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Registry {
    public UpnpService getUpnpService();

    public UpnpServiceConfiguration getConfiguration();

    public ProtocolFactory getProtocolFactory();

    public void shutdown();

    public void pause();

    public void resume();

    public boolean isPaused();

    public void addListener(RegistryListener var1);

    public void removeListener(RegistryListener var1);

    public Collection<RegistryListener> getListeners();

    public boolean notifyDiscoveryStart(RemoteDevice var1);

    public void notifyDiscoveryFailure(RemoteDevice var1, Exception var2);

    public void addDevice(LocalDevice var1) throws RegistrationException;

    public void addDevice(RemoteDevice var1) throws RegistrationException;

    public boolean update(RemoteDeviceIdentity var1);

    public boolean removeDevice(LocalDevice var1);

    public boolean removeDevice(RemoteDevice var1);

    public boolean removeDevice(UDN var1);

    public void removeAllLocalDevices();

    public void removeAllRemoteDevices();

    public Device getDevice(UDN var1, boolean var2);

    public LocalDevice getLocalDevice(UDN var1, boolean var2);

    public RemoteDevice getRemoteDevice(UDN var1, boolean var2);

    public Collection<LocalDevice> getLocalDevices();

    public Collection<RemoteDevice> getRemoteDevices();

    public Collection<Device> getDevices();

    public Collection<Device> getDevices(DeviceType var1);

    public Collection<Device> getDevices(ServiceType var1);

    public Service getService(ServiceReference var1);

    public void addResource(Resource var1);

    public void addResource(Resource var1, int var2);

    public boolean removeResource(Resource var1);

    public Resource getResource(URI var1) throws IllegalArgumentException;

    public <T extends Resource> T getResource(Class<T> var1, URI var2) throws IllegalArgumentException;

    public Collection<Resource> getResources();

    public <T extends Resource> Collection<T> getResources(Class<T> var1);

    public void addLocalSubscription(LocalGENASubscription var1);

    public LocalGENASubscription getLocalSubscription(String var1);

    public boolean updateLocalSubscription(LocalGENASubscription var1);

    public boolean removeLocalSubscription(LocalGENASubscription var1);

    public void addRemoteSubscription(RemoteGENASubscription var1);

    public RemoteGENASubscription getRemoteSubscription(String var1);

    public void updateRemoteSubscription(RemoteGENASubscription var1);

    public void removeRemoteSubscription(RemoteGENASubscription var1);

    public void lockRemoteSubscriptions();

    public void unlockRemoteSubscriptions();
}

