/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Logger;
import org.teleal.cling.model.gena.CancelReason;
import org.teleal.cling.model.gena.GENASubscription;
import org.teleal.cling.model.gena.LocalGENASubscription;
import org.teleal.cling.model.meta.Device;
import org.teleal.cling.model.meta.DeviceIdentity;
import org.teleal.cling.model.meta.LocalDevice;
import org.teleal.cling.model.meta.LocalService;
import org.teleal.cling.model.resource.Resource;
import org.teleal.cling.model.types.UDN;
import org.teleal.cling.protocol.async.SendingNotificationByebye;
import org.teleal.cling.registry.RegistrationException;
import org.teleal.cling.registry.Registry;
import org.teleal.cling.registry.RegistryImpl;
import org.teleal.cling.registry.RegistryItem;
import org.teleal.cling.registry.RegistryItems;
import org.teleal.cling.registry.RegistryListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalItems
extends RegistryItems<LocalDevice, LocalGENASubscription> {
    private static Logger log = Logger.getLogger(Registry.class.getName());
    protected Random randomGenerator = new Random();

    LocalItems(RegistryImpl registry) {
        super(registry);
    }

    @Override
    void add(LocalDevice localDevice) throws RegistrationException {
        if (this.registry.getDevice(((DeviceIdentity)localDevice.getIdentity()).getUdn(), false) != null) {
            log.fine("Ignoring addition, device already registered: " + localDevice);
            return;
        }
        log.fine("Adding local device to registry: " + localDevice);
        for (Resource deviceResource : this.getResources(localDevice)) {
            if (this.registry.getResource(deviceResource.getPathQuery()) != null) {
                throw new RegistrationException("URI namespace conflict with already registered resource: " + deviceResource);
            }
            this.registry.addResource(deviceResource);
            log.fine("Registered resource: " + deviceResource);
        }
        log.fine("Adding item to registry with expiration in seconds: " + ((DeviceIdentity)localDevice.getIdentity()).getMaxAgeSeconds());
        RegistryItem<UDN, LocalDevice> localItem = new RegistryItem<UDN, LocalDevice>(((DeviceIdentity)localDevice.getIdentity()).getUdn(), localDevice, ((DeviceIdentity)localDevice.getIdentity()).getMaxAgeSeconds());
        this.deviceItems.add(localItem);
        log.fine("Registered local device: " + localItem);
        this.advertiseAlive(localDevice);
        for (RegistryListener listener : this.registry.getListeners()) {
            listener.localDeviceAdded(this.registry, localDevice);
        }
    }

    @Override
    Collection<LocalDevice> get() {
        HashSet c = new HashSet();
        for (RegistryItem item : this.deviceItems) {
            c.add(item.getItem());
        }
        return Collections.unmodifiableCollection(c);
    }

    @Override
    boolean remove(LocalDevice localDevice) throws RegistrationException {
        return this.remove(localDevice, false);
    }

    boolean remove(final LocalDevice localDevice, boolean shuttingDown) throws RegistrationException {
        LocalDevice registeredDevice = (LocalDevice)this.get(((DeviceIdentity)localDevice.getIdentity()).getUdn(), true);
        if (registeredDevice != null) {
            log.fine("Removing local device from registry: " + localDevice);
            this.deviceItems.remove(new RegistryItem(((DeviceIdentity)localDevice.getIdentity()).getUdn()));
            for (Resource deviceResource : this.getResources(localDevice)) {
                if (!this.registry.removeResource(deviceResource)) continue;
                log.fine("Unregistered resource: " + deviceResource);
            }
            Iterator it = this.subscriptionItems.iterator();
            while (it.hasNext()) {
                final RegistryItem incomingSubscription = (RegistryItem)it.next();
                UDN subscriptionForUDN = ((DeviceIdentity)((Device)((LocalService)((LocalGENASubscription)incomingSubscription.getItem()).getService()).getDevice()).getIdentity()).getUdn();
                if (!subscriptionForUDN.equals(((DeviceIdentity)registeredDevice.getIdentity()).getUdn())) continue;
                log.fine("Removing incoming subscription: " + (String)incomingSubscription.getKey());
                it.remove();
                if (shuttingDown) continue;
                this.registry.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                    public void run() {
                        ((LocalGENASubscription)incomingSubscription.getItem()).end(CancelReason.DEVICE_WAS_REMOVED);
                    }
                });
            }
            this.advertiseByebye(localDevice, !shuttingDown);
            if (!shuttingDown) {
                for (final RegistryListener listener : this.registry.getListeners()) {
                    this.registry.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                        public void run() {
                            listener.localDeviceRemoved(LocalItems.this.registry, localDevice);
                        }
                    });
                }
            }
            return true;
        }
        return false;
    }

    @Override
    void removeAll() {
        this.removeAll(false);
    }

    void removeAll(boolean shuttingDown) {
        LocalDevice[] allDevices;
        for (LocalDevice device : allDevices = this.get().toArray(new LocalDevice[this.get().size()])) {
            this.remove(device, shuttingDown);
        }
    }

    @Override
    void maintain() {
        if (this.deviceItems.isEmpty()) {
            return;
        }
        HashSet<RegistryItem> expiredLocalItems = new HashSet<RegistryItem>();
        for (RegistryItem localItem : this.deviceItems) {
            if (!localItem.getExpirationDetails().hasExpired(true)) continue;
            log.finer("Local item has expired: " + localItem);
            expiredLocalItems.add(localItem);
        }
        for (RegistryItem expiredLocalItem : expiredLocalItems) {
            log.fine("Refreshing local device advertisement: " + expiredLocalItem.getItem());
            this.advertiseAlive((LocalDevice)expiredLocalItem.getItem());
            expiredLocalItem.getExpirationDetails().stampLastRefresh();
        }
        HashSet<RegistryItem> expiredIncomingSubscriptions = new HashSet<RegistryItem>();
        for (RegistryItem item : this.subscriptionItems) {
            if (!item.getExpirationDetails().hasExpired(false)) continue;
            expiredIncomingSubscriptions.add(item);
        }
        for (RegistryItem subscription : expiredIncomingSubscriptions) {
            log.fine("Removing expired: " + subscription);
            this.removeSubscription((GENASubscription)subscription.getItem());
            ((LocalGENASubscription)subscription.getItem()).end(CancelReason.EXPIRED);
        }
    }

    @Override
    void shutdown() {
        log.fine("Clearing all registered subscriptions to local devices during shutdown");
        this.subscriptionItems.clear();
        log.fine("Removing all local devices from registry during shutdown");
        this.removeAll(true);
    }

    protected void advertiseAlive(final LocalDevice localDevice) {
        this.registry.executeAsyncProtocol(new Runnable(){

            public void run() {
                try {
                    log.finer("Sleeping some milliseconds to avoid flooding the network with ALIVE msgs");
                    Thread.sleep(LocalItems.this.randomGenerator.nextInt(100));
                }
                catch (InterruptedException ex) {
                    log.severe("Background execution interrupted: " + ex.getMessage());
                }
                LocalItems.this.registry.getProtocolFactory().createSendingNotificationAlive(localDevice).run();
            }
        });
    }

    protected void advertiseByebye(LocalDevice localDevice, boolean asynchronous) {
        SendingNotificationByebye prot = this.registry.getProtocolFactory().createSendingNotificationByebye(localDevice);
        if (asynchronous) {
            this.registry.executeAsyncProtocol(prot);
        } else {
            prot.run();
        }
    }
}

