/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.protocol.sync;

import java.util.logging.Logger;
import org.teleal.cling.UpnpService;
import org.teleal.cling.model.gena.CancelReason;
import org.teleal.cling.model.gena.RemoteGENASubscription;
import org.teleal.cling.model.message.StreamRequestMessage;
import org.teleal.cling.model.message.StreamResponseMessage;
import org.teleal.cling.model.message.UpnpResponse;
import org.teleal.cling.model.message.gena.OutgoingUnsubscribeRequestMessage;
import org.teleal.cling.protocol.SendingSync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendingUnsubscribe
extends SendingSync<OutgoingUnsubscribeRequestMessage, StreamResponseMessage> {
    private static final Logger log = Logger.getLogger(SendingUnsubscribe.class.getName());
    protected final RemoteGENASubscription subscription;

    public SendingUnsubscribe(UpnpService upnpService, RemoteGENASubscription subscription) {
        super(upnpService, new OutgoingUnsubscribeRequestMessage(subscription));
        this.subscription = subscription;
    }

    @Override
    protected StreamResponseMessage executeSync() {
        log.fine("Sending unsubscribe request: " + this.getInputMessage());
        final StreamResponseMessage response = this.getUpnpService().getRouter().send((StreamRequestMessage)this.getInputMessage());
        this.getUpnpService().getRegistry().removeRemoteSubscription(this.subscription);
        this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

            public void run() {
                if (response == null) {
                    log.fine("Unsubscribe failed, no response received");
                    SendingUnsubscribe.this.subscription.end(CancelReason.UNSUBSCRIBE_FAILED, null);
                } else if (((UpnpResponse)response.getOperation()).isFailed()) {
                    log.fine("Unsubscribe failed, response was: " + response);
                    SendingUnsubscribe.this.subscription.end(CancelReason.UNSUBSCRIBE_FAILED, (UpnpResponse)response.getOperation());
                } else {
                    log.fine("Unsubscribe successful, response was: " + response);
                    SendingUnsubscribe.this.subscription.end(null, (UpnpResponse)response.getOperation());
                }
            }
        });
        return response;
    }
}

