/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.protocol.sync;

import java.util.logging.Logger;
import org.teleal.cling.UpnpService;
import org.teleal.cling.model.gena.RemoteGENASubscription;
import org.teleal.cling.model.message.StreamRequestMessage;
import org.teleal.cling.model.message.StreamResponseMessage;
import org.teleal.cling.model.message.UpnpResponse;
import org.teleal.cling.model.message.gena.IncomingSubscribeResponseMessage;
import org.teleal.cling.model.message.gena.OutgoingSubscribeRequestMessage;
import org.teleal.cling.model.meta.RemoteDevice;
import org.teleal.cling.model.meta.RemoteDeviceIdentity;
import org.teleal.cling.model.meta.RemoteService;
import org.teleal.cling.protocol.SendingSync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendingSubscribe
extends SendingSync<OutgoingSubscribeRequestMessage, IncomingSubscribeResponseMessage> {
    private static final Logger log = Logger.getLogger(SendingSubscribe.class.getName());
    protected final RemoteGENASubscription subscription;

    public SendingSubscribe(UpnpService upnpService, RemoteGENASubscription subscription) {
        super(upnpService, new OutgoingSubscribeRequestMessage(subscription, subscription.getEventCallbackURLs(upnpService.getRouter().getActiveStreamServers(((RemoteDeviceIdentity)((RemoteDevice)((RemoteService)subscription.getService()).getDevice()).getIdentity()).getDiscoveredOnLocalAddress()), upnpService.getConfiguration().getNamespace())));
        this.subscription = subscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IncomingSubscribeResponseMessage executeSync() {
        if (!((OutgoingSubscribeRequestMessage)this.getInputMessage()).hasCallbackURLs()) {
            log.fine("Subscription failed, no active local callback URLs available (network disabled?)");
            this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                public void run() {
                    SendingSubscribe.this.subscription.fail(null);
                }
            });
            return null;
        }
        log.fine("Sending subscription request: " + this.getInputMessage());
        try {
            this.getUpnpService().getRegistry().lockRemoteSubscriptions();
            StreamResponseMessage response = this.getUpnpService().getRouter().send((StreamRequestMessage)this.getInputMessage());
            if (response == null) {
                log.fine("Subscription failed, no response received");
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                    public void run() {
                        SendingSubscribe.this.subscription.fail(null);
                    }
                });
                IncomingSubscribeResponseMessage incomingSubscribeResponseMessage = null;
                return incomingSubscribeResponseMessage;
            }
            final IncomingSubscribeResponseMessage responseMessage = new IncomingSubscribeResponseMessage(response);
            if (((UpnpResponse)response.getOperation()).isFailed()) {
                log.fine("Subscription failed, response was: " + responseMessage);
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                    public void run() {
                        SendingSubscribe.this.subscription.fail((UpnpResponse)responseMessage.getOperation());
                    }
                });
            } else if (!responseMessage.isVaildHeaders()) {
                log.severe("Subscription failed, invalid or missing (SID, Timeout) response headers");
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                    public void run() {
                        SendingSubscribe.this.subscription.fail((UpnpResponse)responseMessage.getOperation());
                    }
                });
            } else {
                log.fine("Subscription established, adding to registry, response was: " + response);
                this.subscription.setSubscriptionId(responseMessage.getSubscriptionId());
                this.subscription.setActualSubscriptionDurationSeconds(responseMessage.getSubscriptionDurationSeconds());
                this.getUpnpService().getRegistry().addRemoteSubscription(this.subscription);
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                    public void run() {
                        SendingSubscribe.this.subscription.establish();
                    }
                });
            }
            IncomingSubscribeResponseMessage incomingSubscribeResponseMessage = responseMessage;
            return incomingSubscribeResponseMessage;
        }
        finally {
            this.getUpnpService().getRegistry().unlockRemoteSubscriptions();
        }
    }
}

