/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.protocol.sync;

import java.util.logging.Logger;
import org.teleal.cling.UpnpService;
import org.teleal.cling.model.gena.CancelReason;
import org.teleal.cling.model.gena.RemoteGENASubscription;
import org.teleal.cling.model.message.StreamRequestMessage;
import org.teleal.cling.model.message.StreamResponseMessage;
import org.teleal.cling.model.message.UpnpResponse;
import org.teleal.cling.model.message.gena.IncomingSubscribeResponseMessage;
import org.teleal.cling.model.message.gena.OutgoingRenewalRequestMessage;
import org.teleal.cling.protocol.SendingSync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendingRenewal
extends SendingSync<OutgoingRenewalRequestMessage, IncomingSubscribeResponseMessage> {
    private static final Logger log = Logger.getLogger(SendingRenewal.class.getName());
    protected final RemoteGENASubscription subscription;

    public SendingRenewal(UpnpService upnpService, RemoteGENASubscription subscription) {
        super(upnpService, new OutgoingRenewalRequestMessage(subscription));
        this.subscription = subscription;
    }

    @Override
    protected IncomingSubscribeResponseMessage executeSync() {
        log.fine("Sending subscription renewal request: " + this.getInputMessage());
        StreamResponseMessage response = this.getUpnpService().getRouter().send((StreamRequestMessage)this.getInputMessage());
        if (response == null) {
            log.fine("Subscription renewal failed, no response received");
            this.getUpnpService().getRegistry().removeRemoteSubscription(this.subscription);
            this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                public void run() {
                    SendingRenewal.this.subscription.end(CancelReason.RENEWAL_FAILED, null);
                }
            });
            return null;
        }
        final IncomingSubscribeResponseMessage responseMessage = new IncomingSubscribeResponseMessage(response);
        if (((UpnpResponse)response.getOperation()).isFailed()) {
            log.fine("Subscription renewal failed, response was: " + response);
            this.getUpnpService().getRegistry().removeRemoteSubscription(this.subscription);
            this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                public void run() {
                    SendingRenewal.this.subscription.end(CancelReason.RENEWAL_FAILED, (UpnpResponse)responseMessage.getOperation());
                }
            });
        } else {
            log.fine("Subscription renewed, updating in registry, response was: " + response);
            this.subscription.setActualSubscriptionDurationSeconds(responseMessage.getSubscriptionDurationSeconds());
            this.getUpnpService().getRegistry().updateRemoteSubscription(this.subscription);
        }
        return responseMessage;
    }
}

