/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.protocol.sync;

import java.util.logging.Logger;
import org.teleal.cling.UpnpService;
import org.teleal.cling.model.gena.RemoteGENASubscription;
import org.teleal.cling.model.message.StreamRequestMessage;
import org.teleal.cling.model.message.UpnpResponse;
import org.teleal.cling.model.message.gena.IncomingEventRequestMessage;
import org.teleal.cling.model.message.gena.OutgoingEventResponseMessage;
import org.teleal.cling.model.meta.RemoteService;
import org.teleal.cling.model.resource.ServiceEventCallbackResource;
import org.teleal.cling.protocol.ReceivingSync;
import org.teleal.cling.transport.spi.UnsupportedDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceivingEvent
extends ReceivingSync<StreamRequestMessage, OutgoingEventResponseMessage> {
    private static final Logger log = Logger.getLogger(ReceivingEvent.class.getName());

    public ReceivingEvent(UpnpService upnpService, StreamRequestMessage inputMessage) {
        super(upnpService, inputMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OutgoingEventResponseMessage executeSync() {
        ServiceEventCallbackResource resource;
        if (!((StreamRequestMessage)this.getInputMessage()).isContentTypeTextUDA()) {
            log.warning("Received without or with invalid Content-Type: " + this.getInputMessage());
        }
        if ((resource = this.getUpnpService().getRegistry().getResource(ServiceEventCallbackResource.class, ((StreamRequestMessage)this.getInputMessage()).getUri())) == null) {
            log.fine("No local resource found: " + this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.NOT_FOUND));
        }
        final IncomingEventRequestMessage requestMessage = new IncomingEventRequestMessage((StreamRequestMessage)this.getInputMessage(), (RemoteService)resource.getModel());
        if (requestMessage.getSubscrptionId() == null) {
            log.fine("Subscription ID missing in event request: " + this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.PRECONDITION_FAILED));
        }
        if (!requestMessage.hasValidNotificationHeaders()) {
            log.fine("Missing NT and/or NTS headers in event request: " + this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.BAD_REQUEST));
        }
        if (!requestMessage.hasValidNotificationHeaders()) {
            log.fine("Invalid NT and/or NTS headers in event request: " + this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.PRECONDITION_FAILED));
        }
        if (requestMessage.getSequence() == null) {
            log.fine("Sequence missing in event request: " + this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.PRECONDITION_FAILED));
        }
        try {
            this.getUpnpService().getConfiguration().getGenaEventProcessor().readBody(requestMessage);
        }
        catch (UnsupportedDataException ex) {
            log.fine("Can't read request body, " + ex);
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.INTERNAL_SERVER_ERROR));
        }
        try {
            this.getUpnpService().getRegistry().lockRemoteSubscriptions();
            final RemoteGENASubscription subscription = this.getUpnpService().getRegistry().getRemoteSubscription(requestMessage.getSubscrptionId());
            if (subscription == null) {
                log.severe("Invalid subscription ID, no active subscription: " + requestMessage);
                OutgoingEventResponseMessage outgoingEventResponseMessage = new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.PRECONDITION_FAILED));
                return outgoingEventResponseMessage;
            }
            this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                public void run() {
                    log.fine("Calling active subscription with event state variable values");
                    subscription.receive(requestMessage.getSequence(), requestMessage.getStateVariableValues());
                }
            });
        }
        finally {
            this.getUpnpService().getRegistry().unlockRemoteSubscriptions();
        }
        return new OutgoingEventResponseMessage();
    }
}

