/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.protocol.sync;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.teleal.cling.UpnpService;
import org.teleal.cling.model.action.ActionException;
import org.teleal.cling.model.action.ActionInvocation;
import org.teleal.cling.model.message.StreamRequestMessage;
import org.teleal.cling.model.message.StreamResponseMessage;
import org.teleal.cling.model.message.UpnpHeaders;
import org.teleal.cling.model.message.UpnpMessage;
import org.teleal.cling.model.message.UpnpResponse;
import org.teleal.cling.model.message.control.ActionResponseMessage;
import org.teleal.cling.model.message.control.IncomingActionRequestMessage;
import org.teleal.cling.model.message.control.OutgoingActionResponseMessage;
import org.teleal.cling.model.message.header.ContentTypeHeader;
import org.teleal.cling.model.message.header.UpnpHeader;
import org.teleal.cling.model.meta.LocalService;
import org.teleal.cling.model.resource.ServiceControlResource;
import org.teleal.cling.model.types.ErrorCode;
import org.teleal.cling.protocol.ReceivingSync;
import org.teleal.cling.transport.spi.UnsupportedDataException;
import org.teleal.common.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceivingAction
extends ReceivingSync<StreamRequestMessage, StreamResponseMessage> {
    private static final Logger log = Logger.getLogger(ReceivingAction.class.getName());
    protected static final ThreadLocal<IncomingActionRequestMessage> requestThreadLocal = new ThreadLocal();
    protected static final ThreadLocal<UpnpHeaders> extraResponseHeadersThreadLocal = new ThreadLocal();

    public ReceivingAction(UpnpService upnpService, StreamRequestMessage inputMessage) {
        super(upnpService, inputMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StreamResponseMessage executeSync() {
        ActionInvocation<LocalService> invocation;
        ServiceControlResource resource;
        ContentTypeHeader contentTypeHeader = ((StreamRequestMessage)this.getInputMessage()).getHeaders().getFirstHeader(UpnpHeader.Type.CONTENT_TYPE, ContentTypeHeader.class);
        if (contentTypeHeader != null && !contentTypeHeader.isUDACompliantXML()) {
            log.warning("Received invalid Content-Type '" + contentTypeHeader + "': " + this.getInputMessage());
            return new StreamResponseMessage(new UpnpResponse(UpnpResponse.Status.UNSUPPORTED_MEDIA_TYPE));
        }
        if (contentTypeHeader == null) {
            log.warning("Received without Content-Type: " + this.getInputMessage());
        }
        if ((resource = this.getUpnpService().getRegistry().getResource(ServiceControlResource.class, ((StreamRequestMessage)this.getInputMessage()).getUri())) == null) {
            log.fine("No local resource found: " + this.getInputMessage());
            return null;
        }
        log.fine("Found local action resource matching relative request URI: " + ((StreamRequestMessage)this.getInputMessage()).getUri());
        UpnpMessage responseMessage = null;
        try {
            IncomingActionRequestMessage requestMessage = new IncomingActionRequestMessage((StreamRequestMessage)this.getInputMessage(), (LocalService)resource.getModel());
            requestThreadLocal.set(requestMessage);
            extraResponseHeadersThreadLocal.set(new UpnpHeaders());
            log.finer("Created incoming action request message: " + requestMessage);
            invocation = new ActionInvocation(requestMessage.getAction());
            log.fine("Reading body of request message");
            this.getUpnpService().getConfiguration().getSoapActionProcessor().readBody(requestMessage, invocation);
            log.fine("Executing on local service: " + invocation);
            ((LocalService)resource.getModel()).getExecutor(invocation.getAction()).execute(invocation);
            responseMessage = invocation.getFailure() == null ? new OutgoingActionResponseMessage(invocation.getAction()) : new OutgoingActionResponseMessage(UpnpResponse.Status.INTERNAL_SERVER_ERROR, invocation.getAction());
        }
        catch (ActionException ex) {
            log.finer("Error executing local action: " + ex);
            invocation = new ActionInvocation<LocalService>(ex);
            responseMessage = new OutgoingActionResponseMessage(UpnpResponse.Status.INTERNAL_SERVER_ERROR);
        }
        catch (UnsupportedDataException ex) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Error reading action request XML body: " + ex.toString(), Exceptions.unwrap(ex));
            }
            invocation = new ActionInvocation(Exceptions.unwrap(ex) instanceof ActionException ? (ActionException)Exceptions.unwrap(ex) : new ActionException(ErrorCode.ACTION_FAILED, ex.getMessage()));
            responseMessage = new OutgoingActionResponseMessage(UpnpResponse.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            if (responseMessage != null && extraResponseHeadersThreadLocal.get() != null) {
                log.fine("Merging extra headers into action response message: " + extraResponseHeadersThreadLocal.get().size());
                responseMessage.getHeaders().putAll(extraResponseHeadersThreadLocal.get());
            }
            requestThreadLocal.set(null);
            extraResponseHeadersThreadLocal.set(null);
        }
        try {
            log.fine("Writing body of response message");
            this.getUpnpService().getConfiguration().getSoapActionProcessor().writeBody((ActionResponseMessage)((Object)responseMessage), invocation);
            log.fine("Returning finished response message: " + responseMessage);
            return responseMessage;
        }
        catch (UnsupportedDataException ex) {
            log.warning("Failure writing body of response message, sending '500 Internal Server Error' without body");
            log.log(Level.WARNING, "Exception root cause: ", Exceptions.unwrap(ex));
            return new StreamResponseMessage(UpnpResponse.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public static IncomingActionRequestMessage getRequestMessage() {
        return requestThreadLocal.get();
    }

    public static UpnpHeaders getExtraResponseHeaders() {
        return extraResponseHeadersThreadLocal.get();
    }
}

