/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.protocol.async;

import java.util.logging.Logger;
import org.teleal.cling.UpnpService;
import org.teleal.cling.model.ValidationError;
import org.teleal.cling.model.ValidationException;
import org.teleal.cling.model.message.IncomingDatagramMessage;
import org.teleal.cling.model.message.UpnpResponse;
import org.teleal.cling.model.message.discovery.IncomingSearchResponse;
import org.teleal.cling.model.meta.RemoteDevice;
import org.teleal.cling.model.meta.RemoteDeviceIdentity;
import org.teleal.cling.model.types.UDN;
import org.teleal.cling.protocol.ReceivingAsync;
import org.teleal.cling.protocol.RetrieveRemoteDescriptors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceivingSearchResponse
extends ReceivingAsync<IncomingSearchResponse> {
    private static final Logger log = Logger.getLogger(ReceivingSearchResponse.class.getName());

    public ReceivingSearchResponse(UpnpService upnpService, IncomingDatagramMessage<UpnpResponse> inputMessage) {
        super(upnpService, new IncomingSearchResponse(inputMessage));
    }

    @Override
    protected void execute() {
        RemoteDevice rd;
        if (!((IncomingSearchResponse)this.getInputMessage()).isSearchResponseMessage()) {
            log.fine("Ignoring invalid search response message: " + this.getInputMessage());
            return;
        }
        UDN udn = ((IncomingSearchResponse)this.getInputMessage()).getRootDeviceUDN();
        if (udn == null) {
            log.fine("Ignoring search response message without UDN: " + this.getInputMessage());
            return;
        }
        RemoteDeviceIdentity rdIdentity = new RemoteDeviceIdentity((IncomingSearchResponse)this.getInputMessage());
        log.fine("Received device search response: " + rdIdentity);
        if (this.getUpnpService().getRegistry().update(rdIdentity)) {
            log.fine("Remote device was already known: " + udn);
            return;
        }
        try {
            rd = new RemoteDevice(rdIdentity);
        }
        catch (ValidationException ex) {
            log.warning("Validation errors of device during discovery: " + rdIdentity);
            for (ValidationError validationError : ex.getErrors()) {
                log.warning(validationError.toString());
            }
            return;
        }
        if (rdIdentity.getDescriptorURL() == null) {
            log.finer("Ignoring message without location URL header: " + this.getInputMessage());
            return;
        }
        if (rdIdentity.getMaxAgeSeconds() == null) {
            log.finer("Ignoring message without max-age header: " + this.getInputMessage());
            return;
        }
        this.getUpnpService().getConfiguration().getAsyncProtocolExecutor().execute(new RetrieveRemoteDescriptors(this.getUpnpService(), rd));
    }
}

