/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.protocol.async;

import java.util.logging.Logger;
import org.teleal.cling.UpnpService;
import org.teleal.cling.model.ValidationError;
import org.teleal.cling.model.ValidationException;
import org.teleal.cling.model.message.IncomingDatagramMessage;
import org.teleal.cling.model.message.UpnpRequest;
import org.teleal.cling.model.message.discovery.IncomingNotificationRequest;
import org.teleal.cling.model.meta.RemoteDevice;
import org.teleal.cling.model.meta.RemoteDeviceIdentity;
import org.teleal.cling.model.types.UDN;
import org.teleal.cling.protocol.ReceivingAsync;
import org.teleal.cling.protocol.RetrieveRemoteDescriptors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceivingNotification
extends ReceivingAsync<IncomingNotificationRequest> {
    private static final Logger log = Logger.getLogger(ReceivingNotification.class.getName());

    public ReceivingNotification(UpnpService upnpService, IncomingDatagramMessage<UpnpRequest> inputMessage) {
        super(upnpService, new IncomingNotificationRequest(inputMessage));
    }

    @Override
    protected void execute() {
        RemoteDevice rd;
        UDN udn = ((IncomingNotificationRequest)this.getInputMessage()).getUDN();
        if (udn == null) {
            log.fine("Ignoring notification message without UDN: " + this.getInputMessage());
            return;
        }
        RemoteDeviceIdentity rdIdentity = new RemoteDeviceIdentity((IncomingNotificationRequest)this.getInputMessage());
        log.fine("Received device notification: " + rdIdentity);
        try {
            rd = new RemoteDevice(rdIdentity);
        }
        catch (ValidationException ex) {
            log.warning("Validation errors of device during discovery: " + rdIdentity);
            for (ValidationError validationError : ex.getErrors()) {
                log.warning(validationError.toString());
            }
            return;
        }
        if (((IncomingNotificationRequest)this.getInputMessage()).isAliveMessage()) {
            log.fine("Received device ALIVE advertisement, descriptor location is: " + rdIdentity.getDescriptorURL());
            if (rdIdentity.getDescriptorURL() == null) {
                log.finer("Ignoring message without location URL header: " + this.getInputMessage());
                return;
            }
            if (rdIdentity.getMaxAgeSeconds() == null) {
                log.finer("Ignoring message without max-age header: " + this.getInputMessage());
                return;
            }
            if (this.getUpnpService().getRegistry().update(rdIdentity)) {
                log.finer("Remote device was already known: " + udn);
                return;
            }
            this.getUpnpService().getConfiguration().getAsyncProtocolExecutor().execute(new RetrieveRemoteDescriptors(this.getUpnpService(), rd));
        } else if (((IncomingNotificationRequest)this.getInputMessage()).isByeByeMessage()) {
            log.fine("Received device BYEBYE advertisement");
            boolean removed = this.getUpnpService().getRegistry().removeDevice(rd);
            if (removed) {
                log.fine("Removed remote device from registry: " + rd);
            }
        } else {
            log.finer("Ignoring unknown notification message: " + this.getInputMessage());
        }
    }
}

