/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.protocol;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import org.teleal.cling.UpnpService;
import org.teleal.cling.binding.xml.DescriptorBindingException;
import org.teleal.cling.binding.xml.DeviceDescriptorBinder;
import org.teleal.cling.binding.xml.ServiceDescriptorBinder;
import org.teleal.cling.model.ValidationError;
import org.teleal.cling.model.ValidationException;
import org.teleal.cling.model.message.StreamRequestMessage;
import org.teleal.cling.model.message.StreamResponseMessage;
import org.teleal.cling.model.message.UpnpRequest;
import org.teleal.cling.model.message.UpnpResponse;
import org.teleal.cling.model.meta.Icon;
import org.teleal.cling.model.meta.RemoteDevice;
import org.teleal.cling.model.meta.RemoteDeviceIdentity;
import org.teleal.cling.model.meta.RemoteService;
import org.teleal.cling.model.types.ServiceType;
import org.teleal.cling.registry.RegistrationException;
import org.teleal.common.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetrieveRemoteDescriptors
implements Runnable {
    private static final Logger log = Logger.getLogger(RetrieveRemoteDescriptors.class.getName());
    private final UpnpService upnpService;
    private RemoteDevice rd;
    private static final Set<URL> activeRetrievals = new CopyOnWriteArraySet<URL>();

    public RetrieveRemoteDescriptors(UpnpService upnpService, RemoteDevice rd) {
        this.upnpService = upnpService;
        this.rd = rd;
    }

    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        URL deviceURL = ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL();
        if (activeRetrievals.contains(deviceURL)) {
            log.finer("Exiting early, active retrieval for URL already in progress: " + deviceURL);
            return;
        }
        if (this.getUpnpService().getRegistry().getRemoteDevice(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn(), true) != null) {
            log.finer("Exiting early, already discovered: " + deviceURL);
            return;
        }
        try {
            activeRetrievals.add(deviceURL);
            this.describe();
        }
        finally {
            activeRetrievals.remove(deviceURL);
        }
    }

    protected void describe() {
        StreamRequestMessage deviceDescRetrievalMsg = new StreamRequestMessage(UpnpRequest.Method.GET, ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
        log.fine("Sending device descriptor retrieval message: " + deviceDescRetrievalMsg);
        StreamResponseMessage deviceDescMsg = this.getUpnpService().getRouter().send(deviceDescRetrievalMsg);
        if (deviceDescMsg == null) {
            log.warning("Device descriptor retrieval failed, no response: " + ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
            return;
        }
        if (((UpnpResponse)deviceDescMsg.getOperation()).isFailed()) {
            log.warning("Device descriptor retrieval failed: " + ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL() + ", " + ((UpnpResponse)deviceDescMsg.getOperation()).getResponseDetails());
            return;
        }
        if (!deviceDescMsg.isContentTypeTextUDA()) {
            log.warning("Received device descriptor without or with invalid Content-Type: " + ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
        }
        log.fine("Received root device descriptor: " + deviceDescMsg);
        this.describe(deviceDescMsg.getBodyString());
    }

    protected void describe(String descriptorXML) {
        block9: {
            boolean notifiedStart = false;
            RemoteDevice describedDevice = null;
            try {
                DeviceDescriptorBinder deviceDescriptorBinder = this.getUpnpService().getConfiguration().getDeviceDescriptorBinderUDA10();
                describedDevice = deviceDescriptorBinder.describe(this.rd, descriptorXML);
                log.fine("Remote device described (without services) notifying listeners: " + describedDevice);
                notifiedStart = this.getUpnpService().getRegistry().notifyDiscoveryStart(describedDevice);
                log.fine("Hydrating described device's services: " + describedDevice);
                RemoteDevice hydratedDevice = this.describeServices(describedDevice);
                if (hydratedDevice == null) {
                    log.warning("Device service description failed: " + this.rd);
                    if (notifiedStart) {
                        this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, new DescriptorBindingException("Device service description failed: " + this.rd));
                    }
                    return;
                }
                log.fine("Adding fully hydrated remote device to registry: " + hydratedDevice);
                this.getUpnpService().getRegistry().addDevice(hydratedDevice);
            }
            catch (ValidationException ex) {
                log.warning("Could not validate device model: " + this.rd);
                for (ValidationError validationError : ex.getErrors()) {
                    log.warning(validationError.toString());
                }
                if (describedDevice != null && notifiedStart) {
                    this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, ex);
                }
            }
            catch (DescriptorBindingException ex) {
                log.warning("Could not hydrate device or its services from descriptor: " + this.rd);
                log.warning("Cause was: " + Exceptions.unwrap(ex));
                if (describedDevice != null && notifiedStart) {
                    this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, ex);
                }
            }
            catch (RegistrationException ex) {
                log.warning("Adding hydrated device to registry failed: " + this.rd);
                log.warning("Cause was: " + ex.toString());
                if (describedDevice == null || !notifiedStart) break block9;
                this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, ex);
            }
        }
    }

    protected RemoteDevice describeServices(RemoteDevice currentDevice) throws DescriptorBindingException, ValidationException {
        ArrayList<RemoteService> describedServices = new ArrayList<RemoteService>();
        if (currentDevice.hasServices()) {
            List<RemoteService> filteredServices = this.filterExclusiveServices(currentDevice.getServices());
            for (RemoteService service : filteredServices) {
                RemoteService svc = this.describeService(service);
                if (svc == null) {
                    return null;
                }
                describedServices.add(svc);
            }
        }
        ArrayList<RemoteDevice> describedEmbeddedDevices = new ArrayList<RemoteDevice>();
        if (currentDevice.hasEmbeddedDevices()) {
            for (RemoteDevice embeddedDevice : currentDevice.getEmbeddedDevices()) {
                if (embeddedDevice == null) continue;
                RemoteDevice describedEmbeddedDevice = this.describeServices(embeddedDevice);
                if (describedEmbeddedDevice == null) {
                    return null;
                }
                describedEmbeddedDevices.add(describedEmbeddedDevice);
            }
        }
        Icon[] iconDupes = new Icon[currentDevice.getIcons().length];
        for (int i = 0; i < currentDevice.getIcons().length; ++i) {
            Icon icon = currentDevice.getIcons()[i];
            iconDupes[i] = icon.deepCopy();
        }
        return currentDevice.newInstance(((RemoteDeviceIdentity)currentDevice.getIdentity()).getUdn(), currentDevice.getVersion(), currentDevice.getType(), currentDevice.getDetails(), iconDupes, currentDevice.toServiceArray((Collection<RemoteService>)describedServices), (List<RemoteDevice>)describedEmbeddedDevices);
    }

    protected RemoteService describeService(RemoteService service) throws DescriptorBindingException, ValidationException {
        String descriptorContent;
        URL descriptorURL = ((RemoteDevice)service.getDevice()).normalizeURI(service.getDescriptorURI());
        StreamRequestMessage serviceDescRetrievalMsg = new StreamRequestMessage(UpnpRequest.Method.GET, descriptorURL);
        log.fine("Sending service descriptor retrieval message: " + serviceDescRetrievalMsg);
        StreamResponseMessage serviceDescMsg = this.getUpnpService().getRouter().send(serviceDescRetrievalMsg);
        if (serviceDescMsg == null) {
            log.warning("Could not retrieve service descriptor: " + service);
            return null;
        }
        if (((UpnpResponse)serviceDescMsg.getOperation()).isFailed()) {
            log.warning("Service descriptor retrieval failed: " + descriptorURL + ", " + ((UpnpResponse)serviceDescMsg.getOperation()).getResponseDetails());
            return null;
        }
        if (!serviceDescMsg.isContentTypeTextUDA()) {
            log.warning("Received service descriptor without or with invalid Content-Type: " + descriptorURL);
        }
        if ((descriptorContent = serviceDescMsg.getBodyString()) == null || descriptorContent.length() == 0) {
            log.warning("Received empty descriptor:" + descriptorURL);
            return null;
        }
        log.fine("Received service descriptor, hydrating service model: " + serviceDescMsg);
        ServiceDescriptorBinder serviceDescriptorBinder = this.getUpnpService().getConfiguration().getServiceDescriptorBinderUDA10();
        return serviceDescriptorBinder.describe(service, serviceDescMsg.getBodyString());
    }

    protected List<RemoteService> filterExclusiveServices(RemoteService[] services) {
        ServiceType[] exclusiveTypes = this.getUpnpService().getConfiguration().getExclusiveServiceTypes();
        if (exclusiveTypes == null || exclusiveTypes.length == 0) {
            return Arrays.asList(services);
        }
        ArrayList<RemoteService> exclusiveServices = new ArrayList<RemoteService>();
        for (RemoteService discoveredService : services) {
            for (ServiceType exclusiveType : exclusiveTypes) {
                if (discoveredService.getServiceType().implementsVersion(exclusiveType)) {
                    log.fine("Including exlusive service: " + discoveredService);
                    exclusiveServices.add(discoveredService);
                    continue;
                }
                log.fine("Excluding unwanted service: " + exclusiveType);
            }
        }
        return exclusiveServices;
    }
}

