/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.protocol;

import org.teleal.cling.UpnpService;
import org.teleal.cling.model.message.UpnpMessage;
import org.teleal.cling.model.message.header.UpnpHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReceivingAsync<M extends UpnpMessage>
implements Runnable {
    private final UpnpService upnpService;
    private M inputMessage;

    protected ReceivingAsync(UpnpService upnpService, M inputMessage) {
        this.upnpService = upnpService;
        this.inputMessage = inputMessage;
    }

    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    public M getInputMessage() {
        return this.inputMessage;
    }

    @Override
    public void run() {
        boolean proceed;
        try {
            proceed = this.waitBeforeExecution();
        }
        catch (InterruptedException ex) {
            proceed = false;
        }
        if (proceed) {
            this.execute();
        }
    }

    protected boolean waitBeforeExecution() throws InterruptedException {
        return true;
    }

    protected abstract void execute();

    protected <H extends UpnpHeader> H getFirstHeader(UpnpHeader.Type headerType, Class<H> subtype) {
        return ((UpnpMessage)this.getInputMessage()).getHeaders().getFirstHeader(headerType, subtype);
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ")";
    }
}

