/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.protocol;

import java.net.URL;
import java.util.logging.Logger;
import org.teleal.cling.UpnpService;
import org.teleal.cling.model.action.ActionInvocation;
import org.teleal.cling.model.gena.LocalGENASubscription;
import org.teleal.cling.model.gena.RemoteGENASubscription;
import org.teleal.cling.model.message.IncomingDatagramMessage;
import org.teleal.cling.model.message.StreamRequestMessage;
import org.teleal.cling.model.message.UpnpRequest;
import org.teleal.cling.model.message.UpnpResponse;
import org.teleal.cling.model.message.header.UpnpHeader;
import org.teleal.cling.model.meta.LocalDevice;
import org.teleal.cling.model.types.InvalidValueException;
import org.teleal.cling.model.types.NamedServiceType;
import org.teleal.cling.model.types.NotificationSubtype;
import org.teleal.cling.model.types.ServiceType;
import org.teleal.cling.protocol.ProtocolCreationException;
import org.teleal.cling.protocol.ProtocolFactory;
import org.teleal.cling.protocol.ReceivingAsync;
import org.teleal.cling.protocol.ReceivingSync;
import org.teleal.cling.protocol.async.ReceivingNotification;
import org.teleal.cling.protocol.async.ReceivingSearch;
import org.teleal.cling.protocol.async.ReceivingSearchResponse;
import org.teleal.cling.protocol.async.SendingNotificationAlive;
import org.teleal.cling.protocol.async.SendingNotificationByebye;
import org.teleal.cling.protocol.async.SendingSearch;
import org.teleal.cling.protocol.sync.ReceivingAction;
import org.teleal.cling.protocol.sync.ReceivingEvent;
import org.teleal.cling.protocol.sync.ReceivingRetrieval;
import org.teleal.cling.protocol.sync.ReceivingSubscribe;
import org.teleal.cling.protocol.sync.ReceivingUnsubscribe;
import org.teleal.cling.protocol.sync.SendingAction;
import org.teleal.cling.protocol.sync.SendingEvent;
import org.teleal.cling.protocol.sync.SendingRenewal;
import org.teleal.cling.protocol.sync.SendingSubscribe;
import org.teleal.cling.protocol.sync.SendingUnsubscribe;

public class ProtocolFactoryImpl
implements ProtocolFactory {
    private static final Logger log = Logger.getLogger(ProtocolFactory.class.getName());
    protected final UpnpService upnpService;

    public ProtocolFactoryImpl(UpnpService upnpService) {
        log.fine("Creating ProtocolFactory: " + this.getClass().getName());
        this.upnpService = upnpService;
    }

    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    public ReceivingAsync createReceivingAsync(IncomingDatagramMessage message) throws ProtocolCreationException {
        log.fine("Creating protocol for incoming asynchronous: " + message);
        if (message.getOperation() instanceof UpnpRequest) {
            IncomingDatagramMessage incomingRequest = message;
            switch (((UpnpRequest)incomingRequest.getOperation()).getMethod()) {
                case NOTIFY: {
                    return this.isByeBye(incomingRequest) || this.isSupportedServiceAdvertisement(incomingRequest) ? new ReceivingNotification(this.getUpnpService(), incomingRequest) : null;
                }
                case MSEARCH: {
                    return new ReceivingSearch(this.getUpnpService(), incomingRequest);
                }
            }
        } else if (message.getOperation() instanceof UpnpResponse) {
            IncomingDatagramMessage incomingResponse = message;
            return this.isSupportedServiceAdvertisement(incomingResponse) ? new ReceivingSearchResponse(this.getUpnpService(), incomingResponse) : null;
        }
        throw new ProtocolCreationException("Protocol for incoming datagram message not found: " + message);
    }

    protected boolean isByeBye(IncomingDatagramMessage message) {
        String ntsHeader = message.getHeaders().getFirstHeader(UpnpHeader.Type.NTS.getHttpName());
        return ntsHeader != null && ntsHeader.equals(NotificationSubtype.BYEBYE.getHeaderString());
    }

    protected boolean isSupportedServiceAdvertisement(IncomingDatagramMessage message) {
        ServiceType[] exclusiveServiceTypes = this.getUpnpService().getConfiguration().getExclusiveServiceTypes();
        if (exclusiveServiceTypes == null) {
            return false;
        }
        if (exclusiveServiceTypes.length == 0) {
            return true;
        }
        String usnHeader = message.getHeaders().getFirstHeader(UpnpHeader.Type.USN.getHttpName());
        if (usnHeader == null) {
            return false;
        }
        try {
            NamedServiceType nst = NamedServiceType.valueOf(usnHeader);
            for (ServiceType exclusiveServiceType : exclusiveServiceTypes) {
                if (!nst.getServiceType().implementsVersion(exclusiveServiceType)) continue;
                return true;
            }
        }
        catch (InvalidValueException ex) {
            log.finest("Not a named service type header value: " + usnHeader);
        }
        log.fine("Service advertisement not supported, dropping it: " + usnHeader);
        return false;
    }

    public ReceivingSync createReceivingSync(StreamRequestMessage message) throws ProtocolCreationException {
        log.fine("Creating protocol for incoming synchronous: " + message);
        if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.GET)) {
            return new ReceivingRetrieval(this.getUpnpService(), message);
        }
        if (this.getUpnpService().getConfiguration().getNamespace().isControlPath(message.getUri())) {
            if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.POST)) {
                return new ReceivingAction(this.getUpnpService(), message);
            }
        } else if (this.getUpnpService().getConfiguration().getNamespace().isEventSubscriptionPath(message.getUri())) {
            if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.SUBSCRIBE)) {
                return new ReceivingSubscribe(this.getUpnpService(), message);
            }
            if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.UNSUBSCRIBE)) {
                return new ReceivingUnsubscribe(this.getUpnpService(), message);
            }
        } else if (this.getUpnpService().getConfiguration().getNamespace().isEventCallbackPath(message.getUri()) && ((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.NOTIFY)) {
            return new ReceivingEvent(this.getUpnpService(), message);
        }
        throw new ProtocolCreationException("Protocol for message type not found: " + message);
    }

    public SendingNotificationAlive createSendingNotificationAlive(LocalDevice localDevice) {
        return new SendingNotificationAlive(this.getUpnpService(), localDevice);
    }

    public SendingNotificationByebye createSendingNotificationByebye(LocalDevice localDevice) {
        return new SendingNotificationByebye(this.getUpnpService(), localDevice);
    }

    public SendingSearch createSendingSearch(UpnpHeader searchTarget, int mxSeconds) {
        return new SendingSearch(this.getUpnpService(), searchTarget, mxSeconds);
    }

    public SendingAction createSendingAction(ActionInvocation actionInvocation, URL controlURL) {
        return new SendingAction(this.getUpnpService(), actionInvocation, controlURL);
    }

    public SendingSubscribe createSendingSubscribe(RemoteGENASubscription subscription) {
        return new SendingSubscribe(this.getUpnpService(), subscription);
    }

    public SendingRenewal createSendingRenewal(RemoteGENASubscription subscription) {
        return new SendingRenewal(this.getUpnpService(), subscription);
    }

    public SendingUnsubscribe createSendingUnsubscribe(RemoteGENASubscription subscription) {
        return new SendingUnsubscribe(this.getUpnpService(), subscription);
    }

    public SendingEvent createSendingEvent(LocalGENASubscription subscription) {
        return new SendingEvent(this.getUpnpService(), subscription);
    }
}

