/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teleal.cling.model.types.InvalidValueException;
import org.teleal.cling.model.types.ServiceType;

public class UDAServiceType
extends ServiceType {
    public static final String DEFAULT_NAMESPACE = "schemas-upnp-org";
    public static final Pattern PATTERN = Pattern.compile("urn:schemas-upnp-org:service:([a-zA-Z_0-9\\-]{1,64}):([0-9]+).*");

    public UDAServiceType(String type) {
        this(type, 1);
    }

    public UDAServiceType(String type, int version) {
        super(DEFAULT_NAMESPACE, type, version);
    }

    public static UDAServiceType valueOf(String s) throws InvalidValueException {
        Matcher matcher = PATTERN.matcher(s);
        if (matcher.matches()) {
            return new UDAServiceType(matcher.group(1), Integer.valueOf(matcher.group(2)));
        }
        throw new InvalidValueException("Can't parse UDA service type string (namespace/type/version): " + s);
    }
}

