/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.types;

import org.teleal.cling.model.types.AbstractDatatype;
import org.teleal.cling.model.types.InvalidValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortDatatype
extends AbstractDatatype<Short> {
    @Override
    public boolean isHandlingJavaType(Class type) {
        return type == Short.TYPE || Short.class.isAssignableFrom(type);
    }

    @Override
    public Short valueOf(String s) throws InvalidValueException {
        if (s.equals("")) {
            return null;
        }
        try {
            Short value = Short.parseShort(s);
            if (!this.isValid(value)) {
                throw new InvalidValueException("Not a valid short: " + s);
            }
            return value;
        }
        catch (NumberFormatException ex) {
            throw new InvalidValueException("Can't convert string to number: " + s, ex);
        }
    }
}

