/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.types;

import org.teleal.cling.model.types.InvalidValueException;
import org.teleal.cling.model.types.ServiceType;
import org.teleal.cling.model.types.UDN;

public class NamedServiceType {
    private UDN udn;
    private ServiceType serviceType;

    public NamedServiceType(UDN udn, ServiceType serviceType) {
        this.udn = udn;
        this.serviceType = serviceType;
    }

    public UDN getUdn() {
        return this.udn;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public static NamedServiceType valueOf(String s) throws InvalidValueException {
        UDN udn;
        String[] strings = s.split("::");
        if (strings.length != 2) {
            throw new InvalidValueException("Can't parse UDN::ServiceType from: " + s);
        }
        try {
            udn = UDN.valueOf(strings[0]);
        }
        catch (Exception ex) {
            throw new InvalidValueException("Can't parse UDN: " + strings[0]);
        }
        ServiceType serviceType = ServiceType.valueOf(strings[1]);
        return new NamedServiceType(udn, serviceType);
    }

    public String toString() {
        return this.getUdn().toString() + "::" + this.getServiceType().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof NamedServiceType)) {
            return false;
        }
        NamedServiceType that = (NamedServiceType)o;
        if (!this.serviceType.equals(that.serviceType)) {
            return false;
        }
        return this.udn.equals(that.udn);
    }

    public int hashCode() {
        int result = this.udn.hashCode();
        result = 31 * result + this.serviceType.hashCode();
        return result;
    }
}

