/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.types;

import org.teleal.cling.model.types.AbstractDatatype;
import org.teleal.cling.model.types.InvalidValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerDatatype
extends AbstractDatatype<Integer> {
    private int byteSize;

    public IntegerDatatype(int byteSize) {
        this.byteSize = byteSize;
    }

    @Override
    public boolean isHandlingJavaType(Class type) {
        return type == Integer.TYPE || Integer.class.isAssignableFrom(type);
    }

    @Override
    public Integer valueOf(String s) throws InvalidValueException {
        if (s.equals("")) {
            return null;
        }
        try {
            Integer value = Integer.parseInt(s);
            if (!this.isValid(value)) {
                throw new InvalidValueException("Not a " + this.getByteSize() + " byte(s) integer: " + s);
            }
            return value;
        }
        catch (NumberFormatException ex) {
            throw new InvalidValueException("Can't convert string to number: " + s, ex);
        }
    }

    @Override
    public boolean isValid(Integer value) {
        return value == null || value >= this.getMinValue() && value <= this.getMaxValue();
    }

    public int getMinValue() {
        switch (this.getByteSize()) {
            case 1: {
                return -128;
            }
            case 2: {
                return Short.MIN_VALUE;
            }
            case 4: {
                return Integer.MIN_VALUE;
            }
        }
        throw new IllegalArgumentException("Invalid integer byte size: " + this.getByteSize());
    }

    public int getMaxValue() {
        switch (this.getByteSize()) {
            case 1: {
                return 127;
            }
            case 2: {
                return Short.MAX_VALUE;
            }
            case 4: {
                return Integer.MAX_VALUE;
            }
        }
        throw new IllegalArgumentException("Invalid integer byte size: " + this.getByteSize());
    }

    public int getByteSize() {
        return this.byteSize;
    }
}

