/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.types;

import org.teleal.cling.model.types.AbstractDatatype;
import org.teleal.cling.model.types.InvalidValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatDatatype
extends AbstractDatatype<Float> {
    @Override
    public boolean isHandlingJavaType(Class type) {
        return type == Float.TYPE || Float.class.isAssignableFrom(type);
    }

    @Override
    public Float valueOf(String s) throws InvalidValueException {
        if (s.equals("")) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(s));
        }
        catch (NumberFormatException ex) {
            throw new InvalidValueException("Can't convert string to number: " + s, ex);
        }
    }
}

