/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teleal.cling.model.types.InvalidValueException;
import org.teleal.cling.model.types.UDADeviceType;

public class DeviceType {
    public static final Pattern PATTERN = Pattern.compile("urn:([a-zA-Z0-9\\-\\.]+):device:([a-zA-Z_0-9\\-]{1,64}):([0-9]+).*");
    private String namespace;
    private String type;
    private int version = 1;

    public DeviceType(String namespace, String type) {
        this(namespace, type, 1);
    }

    public DeviceType(String namespace, String type, int version) {
        if (namespace != null && !namespace.matches("[a-zA-Z0-9\\-\\.]+")) {
            throw new IllegalArgumentException("Device type namespace contains illegal characters");
        }
        this.namespace = namespace;
        if (type != null && !type.matches("[a-zA-Z_0-9\\-]{1,64}")) {
            throw new IllegalArgumentException("Device type suffix too long (64) or contains illegal characters");
        }
        this.type = type;
        this.version = version;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    public static DeviceType valueOf(String s) throws InvalidValueException {
        UDADeviceType deviceType = null;
        s = s.replaceAll("\\s", "");
        try {
            deviceType = UDADeviceType.valueOf(s);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (deviceType == null) {
            Matcher matcher = PATTERN.matcher(s);
            if (matcher.matches()) {
                return new DeviceType(matcher.group(1), matcher.group(2), Integer.valueOf(matcher.group(3)));
            }
            throw new InvalidValueException("Can't parse device type string (namespace/type/version): " + s);
        }
        return deviceType;
    }

    public boolean implementsVersion(DeviceType that) {
        if (!this.namespace.equals(that.namespace)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        return this.version >= that.version;
    }

    public String getDisplayString() {
        return this.getType();
    }

    public String toString() {
        return "urn:" + this.getNamespace() + ":device:" + this.getType() + ":" + this.getVersion();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof DeviceType)) {
            return false;
        }
        DeviceType that = (DeviceType)o;
        if (this.version != that.version) {
            return false;
        }
        if (!this.namespace.equals(that.namespace)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.namespace.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.version;
        return result;
    }
}

