/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.types;

import org.teleal.cling.model.types.AbstractDatatype;
import org.teleal.cling.model.types.InvalidValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanDatatype
extends AbstractDatatype<Boolean> {
    @Override
    public boolean isHandlingJavaType(Class type) {
        return type == Boolean.TYPE || Boolean.class.isAssignableFrom(type);
    }

    @Override
    public Boolean valueOf(String s) throws InvalidValueException {
        if (s.equals("")) {
            return null;
        }
        if (s.equals("1") || s.toUpperCase().equals("YES") || s.toUpperCase().equals("TRUE")) {
            return true;
        }
        if (s.equals("0") || s.toUpperCase().equals("NO") || s.toUpperCase().equals("FALSE")) {
            return false;
        }
        throw new InvalidValueException("Invalid boolean value string: " + s);
    }

    @Override
    public String getString(Boolean value) throws InvalidValueException {
        if (value == null) {
            return "";
        }
        return value != false ? "1" : "0";
    }
}

