/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.types;

import org.teleal.cling.model.types.AbstractDatatype;
import org.teleal.cling.model.types.InvalidValueException;
import org.teleal.common.util.Base64Coder;
import org.teleal.common.util.ByteArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Base64Datatype
extends AbstractDatatype<Byte[]> {
    @Override
    public Class<Byte[]> getValueType() {
        return Byte[].class;
    }

    @Override
    public Byte[] valueOf(String s) throws InvalidValueException {
        if (s.equals("")) {
            return null;
        }
        try {
            return ByteArray.toWrapper(Base64Coder.decode(s));
        }
        catch (Exception ex) {
            throw new InvalidValueException(ex.getMessage(), ex);
        }
    }

    @Override
    public String getString(Byte[] value) throws InvalidValueException {
        if (value == null) {
            return "";
        }
        try {
            return new String(Base64Coder.encode(ByteArray.toPrimitive(value)));
        }
        catch (Exception ex) {
            throw new InvalidValueException(ex.getMessage(), ex);
        }
    }
}

