/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.profile;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.teleal.cling.model.meta.DeviceDetails;
import org.teleal.cling.model.profile.ControlPointInfo;
import org.teleal.cling.model.profile.DeviceDetailsProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderDeviceDetailsProvider
implements DeviceDetailsProvider {
    private final DeviceDetails defaultDeviceDetails;
    private final Map<Key, DeviceDetails> headerDetails;

    public HeaderDeviceDetailsProvider(DeviceDetails defaultDeviceDetails) {
        this(defaultDeviceDetails, null);
    }

    public HeaderDeviceDetailsProvider(DeviceDetails defaultDeviceDetails, Map<Key, DeviceDetails> headerDetails) {
        this.defaultDeviceDetails = defaultDeviceDetails;
        this.headerDetails = headerDetails != null ? headerDetails : new HashMap();
    }

    public DeviceDetails getDefaultDeviceDetails() {
        return this.defaultDeviceDetails;
    }

    public Map<Key, DeviceDetails> getHeaderDetails() {
        return this.headerDetails;
    }

    @Override
    public DeviceDetails provide(ControlPointInfo info) {
        if (info == null || info.getHeaders().isEmpty()) {
            return this.getDefaultDeviceDetails();
        }
        for (Key key : this.getHeaderDetails().keySet()) {
            Object headerValues = info.getHeaders().get(key.getHeaderName());
            if (headerValues == null) continue;
            Iterator i$ = headerValues.iterator();
            while (i$.hasNext()) {
                String headerValue = (String)i$.next();
                if (!key.isValuePatternMatch(headerValue)) continue;
                return this.getHeaderDetails().get(key);
            }
        }
        return this.getDefaultDeviceDetails();
    }

    public static class Key {
        final String headerName;
        final String valuePattern;
        final Pattern pattern;

        public Key(String headerName, String valuePattern) {
            this.headerName = headerName;
            this.valuePattern = valuePattern;
            this.pattern = Pattern.compile(valuePattern, 2);
        }

        public String getHeaderName() {
            return this.headerName;
        }

        public String getValuePattern() {
            return this.valuePattern;
        }

        public boolean isValuePatternMatch(String value) {
            return this.pattern.matcher(value).matches();
        }
    }
}

