/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.meta;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.teleal.cling.model.ValidationError;
import org.teleal.cling.model.ValidationException;
import org.teleal.cling.model.meta.Action;
import org.teleal.cling.model.meta.QueryStateVariableAction;
import org.teleal.cling.model.meta.RemoteDevice;
import org.teleal.cling.model.meta.Service;
import org.teleal.cling.model.meta.StateVariable;
import org.teleal.cling.model.types.ServiceId;
import org.teleal.cling.model.types.ServiceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteService
extends Service<RemoteDevice, RemoteService> {
    private final URI descriptorURI;
    private final URI controlURI;
    private final URI eventSubscriptionURI;

    public RemoteService(ServiceType serviceType, ServiceId serviceId, URI descriptorURI, URI controlURI, URI eventSubscriptionURI) throws ValidationException {
        this(serviceType, serviceId, descriptorURI, controlURI, eventSubscriptionURI, null, null);
    }

    public RemoteService(ServiceType serviceType, ServiceId serviceId, URI descriptorURI, URI controlURI, URI eventSubscriptionURI, Action<RemoteService>[] actions, StateVariable<RemoteService>[] stateVariables) throws ValidationException {
        super(serviceType, serviceId, actions, stateVariables);
        this.descriptorURI = descriptorURI;
        this.controlURI = controlURI;
        this.eventSubscriptionURI = eventSubscriptionURI;
        List<ValidationError> errors = this.validateThis();
        if (errors.size() > 0) {
            throw new ValidationException("Validation of device graph failed, call getErrors() on exception", errors);
        }
    }

    @Override
    public Action getQueryStateVariableAction() {
        return new QueryStateVariableAction<RemoteService>(this);
    }

    public URI getDescriptorURI() {
        return this.descriptorURI;
    }

    public URI getControlURI() {
        return this.controlURI;
    }

    public URI getEventSubscriptionURI() {
        return this.eventSubscriptionURI;
    }

    public List<ValidationError> validateThis() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getDescriptorURI() == null) {
            errors.add(new ValidationError(this.getClass(), "descriptorURI", "Descriptor location (SCPDURL) is required"));
        }
        if (this.getControlURI() == null) {
            errors.add(new ValidationError(this.getClass(), "controlURI", "Control URL is required"));
        }
        if (this.getEventSubscriptionURI() == null) {
            errors.add(new ValidationError(this.getClass(), "eventSubscriptionURI", "Event subscription URL is required"));
        }
        return errors;
    }
}

