/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.meta;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.teleal.cling.model.Namespace;
import org.teleal.cling.model.ValidationError;
import org.teleal.cling.model.ValidationException;
import org.teleal.cling.model.meta.Action;
import org.teleal.cling.model.meta.Device;
import org.teleal.cling.model.meta.DeviceDetails;
import org.teleal.cling.model.meta.DeviceIdentity;
import org.teleal.cling.model.meta.Icon;
import org.teleal.cling.model.meta.LocalService;
import org.teleal.cling.model.meta.Service;
import org.teleal.cling.model.meta.StateVariable;
import org.teleal.cling.model.meta.UDAVersion;
import org.teleal.cling.model.profile.ControlPointInfo;
import org.teleal.cling.model.profile.DeviceDetailsProvider;
import org.teleal.cling.model.resource.DeviceDescriptorResource;
import org.teleal.cling.model.resource.IconResource;
import org.teleal.cling.model.resource.Resource;
import org.teleal.cling.model.resource.ServiceControlResource;
import org.teleal.cling.model.resource.ServiceDescriptorResource;
import org.teleal.cling.model.resource.ServiceEventSubscriptionResource;
import org.teleal.cling.model.types.DeviceType;
import org.teleal.cling.model.types.ServiceId;
import org.teleal.cling.model.types.ServiceType;
import org.teleal.cling.model.types.UDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDevice
extends Device<DeviceIdentity, LocalDevice, LocalService> {
    private final DeviceDetailsProvider deviceDetailsProvider;

    public LocalDevice(DeviceIdentity identity) throws ValidationException {
        super(identity);
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, LocalService service) throws ValidationException {
        super(identity, type, details, null, (Service[])new LocalService[]{service});
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetailsProvider deviceDetailsProvider, LocalService service) throws ValidationException {
        super(identity, type, null, null, (Service[])new LocalService[]{service});
        this.deviceDetailsProvider = deviceDetailsProvider;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetailsProvider deviceDetailsProvider, LocalService service, LocalDevice embeddedDevice) throws ValidationException {
        super(identity, type, null, null, (Service[])new LocalService[]{service}, (Device[])new LocalDevice[]{embeddedDevice});
        this.deviceDetailsProvider = deviceDetailsProvider;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, LocalService service, LocalDevice embeddedDevice) throws ValidationException {
        super(identity, type, details, null, (Service[])new LocalService[]{service}, (Device[])new LocalDevice[]{embeddedDevice});
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, LocalService[] services) throws ValidationException {
        super(identity, type, details, null, (Service[])services);
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, LocalService[] services, LocalDevice[] embeddedDevices) throws ValidationException {
        super(identity, type, details, null, (Service[])services, (Device[])embeddedDevices);
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, Icon icon, LocalService service) throws ValidationException {
        super(identity, type, details, new Icon[]{icon}, (Service[])new LocalService[]{service});
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, Icon icon, LocalService service, LocalDevice embeddedDevice) throws ValidationException {
        super(identity, type, details, new Icon[]{icon}, (Service[])new LocalService[]{service}, (Device[])new LocalDevice[]{embeddedDevice});
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, Icon icon, LocalService[] services) throws ValidationException {
        super(identity, type, details, new Icon[]{icon}, (Service[])services);
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetailsProvider deviceDetailsProvider, Icon icon, LocalService[] services) throws ValidationException {
        super(identity, type, null, new Icon[]{icon}, (Service[])services);
        this.deviceDetailsProvider = deviceDetailsProvider;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, Icon icon, LocalService[] services, LocalDevice[] embeddedDevices) throws ValidationException {
        super(identity, type, details, new Icon[]{icon}, (Service[])services, (Device[])embeddedDevices);
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, Icon[] icons, LocalService service) throws ValidationException {
        super(identity, type, details, icons, (Service[])new LocalService[]{service});
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, Icon[] icons, LocalService service, LocalDevice embeddedDevice) throws ValidationException {
        super(identity, type, details, icons, (Service[])new LocalService[]{service}, (Device[])new LocalDevice[]{embeddedDevice});
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetailsProvider deviceDetailsProvider, Icon[] icons, LocalService service, LocalDevice embeddedDevice) throws ValidationException {
        super(identity, type, null, icons, (Service[])new LocalService[]{service}, (Device[])new LocalDevice[]{embeddedDevice});
        this.deviceDetailsProvider = deviceDetailsProvider;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, Icon[] icons, LocalService[] services) throws ValidationException {
        super(identity, type, details, icons, (Service[])services);
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, DeviceType type, DeviceDetails details, Icon[] icons, LocalService[] services, LocalDevice[] embeddedDevices) throws ValidationException {
        super(identity, type, details, icons, (Service[])services, (Device[])embeddedDevices);
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, UDAVersion version, DeviceType type, DeviceDetails details, Icon[] icons, LocalService[] services, LocalDevice[] embeddedDevices) throws ValidationException {
        super(identity, version, type, details, icons, (Service[])services, (Device[])embeddedDevices);
        this.deviceDetailsProvider = null;
    }

    public LocalDevice(DeviceIdentity identity, UDAVersion version, DeviceType type, DeviceDetailsProvider deviceDetailsProvider, Icon[] icons, LocalService[] services, LocalDevice[] embeddedDevices) throws ValidationException {
        super(identity, version, type, null, icons, (Service[])services, (Device[])embeddedDevices);
        this.deviceDetailsProvider = deviceDetailsProvider;
    }

    @Override
    public DeviceDetails getDetails(ControlPointInfo info) {
        if (this.deviceDetailsProvider != null) {
            return this.deviceDetailsProvider.provide(info);
        }
        return this.getDetails();
    }

    public LocalService[] getServices() {
        return this.services != null ? (LocalService[])this.services : new LocalService[]{};
    }

    public LocalDevice[] getEmbeddedDevices() {
        return this.embeddedDevices != null ? (LocalDevice[])this.embeddedDevices : new LocalDevice[]{};
    }

    public LocalDevice newInstance(UDN udn, UDAVersion version, DeviceType type, DeviceDetails details, Icon[] icons, LocalService[] services, List<LocalDevice> embeddedDevices) throws ValidationException {
        return new LocalDevice(new DeviceIdentity(udn, ((DeviceIdentity)this.getIdentity()).getMaxAgeSeconds()), version, type, details, icons, services, embeddedDevices.size() > 0 ? embeddedDevices.toArray(new LocalDevice[embeddedDevices.size()]) : null);
    }

    @Override
    public LocalService newInstance(ServiceType serviceType, ServiceId serviceId, URI descriptorURI, URI controlURI, URI eventSubscriptionURI, Action<LocalService>[] actions, StateVariable<LocalService>[] stateVariables) throws ValidationException {
        return new LocalService(serviceType, serviceId, (Action[])actions, (StateVariable[])stateVariables);
    }

    public LocalDevice[] toDeviceArray(Collection<LocalDevice> col) {
        return col.toArray(new LocalDevice[col.size()]);
    }

    public LocalService[] newServiceArray(int size) {
        return new LocalService[size];
    }

    public LocalService[] toServiceArray(Collection<LocalService> col) {
        return col.toArray(new LocalService[col.size()]);
    }

    @Override
    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        errors.addAll(super.validate());
        if (this.hasIcons()) {
            for (Icon icon : this.getIcons()) {
                if (icon.getUri().isAbsolute()) {
                    errors.add(new ValidationError(this.getClass(), "icons", "Local icon URI can not be absolute: " + icon.getUri()));
                }
                if (icon.getUri().toString().contains("../")) {
                    errors.add(new ValidationError(this.getClass(), "icons", "Local icon URI must not contain '../': " + icon.getUri()));
                }
                if (!icon.getUri().toString().startsWith("/")) continue;
                errors.add(new ValidationError(this.getClass(), "icons", "Local icon URI must not start with '/': " + icon.getUri()));
            }
        }
        return errors;
    }

    @Override
    public Resource[] discoverResources(Namespace namespace) {
        ArrayList<Resource> discovered = new ArrayList<Resource>();
        if (this.isRoot()) {
            discovered.add(new DeviceDescriptorResource(namespace.getDescriptorPath(this), this));
        }
        for (LocalService service : this.getServices()) {
            discovered.add(new ServiceDescriptorResource(namespace.getDescriptorPath(service), service));
            discovered.add(new ServiceControlResource(namespace.getControlPath(service), service));
            discovered.add(new ServiceEventSubscriptionResource(namespace.getEventSubscriptionPath(service), service));
        }
        for (Icon icon : this.getIcons()) {
            discovered.add(new IconResource(namespace.prefixIfRelative(this, icon.getUri()), icon));
        }
        if (this.hasEmbeddedDevices()) {
            for (LocalDevice embeddedDevice : this.getEmbeddedDevices()) {
                discovered.addAll(Arrays.asList(((Device)embeddedDevice).discoverResources(namespace)));
            }
        }
        return discovered.toArray(new Resource[discovered.size()]);
    }

    @Override
    public LocalDevice getRoot() {
        if (this.isRoot()) {
            return this;
        }
        LocalDevice current = this;
        while (current.getParentDevice() != null) {
            current = (LocalDevice)current.getParentDevice();
        }
        return current;
    }

    @Override
    public LocalDevice findDevice(UDN udn) {
        return this.find(udn, this);
    }
}

