/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.meta;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.teleal.cling.model.Validatable;
import org.teleal.cling.model.ValidationError;
import org.teleal.cling.model.meta.Device;
import org.teleal.cling.model.meta.StateVariable;
import org.teleal.cling.model.types.BinHexDatatype;
import org.teleal.common.io.IO;
import org.teleal.common.util.ByteArray;
import org.teleal.common.util.MimeType;
import org.teleal.common.util.URIUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Icon
implements Validatable {
    private static final Logger log = Logger.getLogger(StateVariable.class.getName());
    private final MimeType mimeType;
    private final int width;
    private final int height;
    private final int depth;
    private final URI uri;
    private final byte[] data;
    private Device device;

    public Icon(String mimeType, int width, int height, int depth, String uri) throws IllegalArgumentException {
        this(mimeType, width, height, depth, URI.create(uri), "");
    }

    public Icon(String mimeType, int width, int height, int depth, URI uri) {
        this(mimeType, width, height, depth, uri, "");
    }

    public Icon(String mimeType, int width, int height, int depth, URI uri, String data) {
        this(mimeType, width, height, depth, uri, data != null && !data.equals("") ? ByteArray.toPrimitive(new BinHexDatatype().valueOf(data)) : null);
    }

    public Icon(String mimeType, int width, int height, int depth, URL url) throws IOException {
        this(mimeType, width, height, depth, new File(URIUtil.toURI(url)));
    }

    public Icon(String mimeType, int width, int height, int depth, URI uri, InputStream is) throws IOException {
        this(mimeType, width, height, depth, uri, IO.readBytes(is));
    }

    public Icon(String mimeType, int width, int height, int depth, File file) throws IOException {
        this(mimeType, width, height, depth, URI.create(file.getName()), IO.readBytes(file));
    }

    public Icon(String mimeType, int width, int height, int depth, URI uri, byte[] data) {
        this(mimeType != null && mimeType.length() > 0 ? MimeType.valueOf(mimeType) : null, width, height, depth, uri, data);
    }

    public Icon(MimeType mimeType, int width, int height, int depth, URI uri, byte[] data) {
        this.mimeType = mimeType;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.uri = uri;
        this.data = data;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public URI getUri() {
        return this.uri;
    }

    public byte[] getData() {
        return this.data;
    }

    public Device getDevice() {
        return this.device;
    }

    void setDevice(Device device) {
        if (this.device != null) {
            throw new IllegalStateException("Final value has been set already, model is immutable");
        }
        this.device = device;
    }

    @Override
    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getMimeType() == null) {
            log.warning("UPnP specification violation of: " + this.getDevice());
            log.warning("Invalid icon, missing mime type: " + this);
        }
        if (this.getWidth() == 0) {
            log.warning("UPnP specification violation of: " + this.getDevice());
            log.warning("Invalid icon, missing width: " + this);
        }
        if (this.getHeight() == 0) {
            log.warning("UPnP specification violation of: " + this.getDevice());
            log.warning("Invalid icon, missing height: " + this);
        }
        if (this.getDepth() == 0) {
            log.warning("UPnP specification violation of: " + this.getDevice());
            log.warning("Invalid icon, missing bitmap depth: " + this);
        }
        if (this.getUri() == null) {
            errors.add(new ValidationError(this.getClass(), "uri", "URL is required"));
        }
        try {
            URL testURI = this.getUri().toURL();
            if (testURI == null) {
                throw new MalformedURLException();
            }
        }
        catch (MalformedURLException ex) {
            errors.add(new ValidationError(this.getClass(), "uri", "URL must be valid: " + ex.getMessage()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return errors;
    }

    public Icon deepCopy() {
        return new Icon(this.getMimeType(), this.getWidth(), this.getHeight(), this.getDepth(), this.getUri(), this.getData());
    }

    public String toString() {
        return "Icon(" + this.getWidth() + "x" + this.getHeight() + ", " + this.getMimeType() + ") " + this.getUri();
    }
}

