/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.message.header;

import org.teleal.cling.model.message.header.InvalidHeaderException;
import org.teleal.cling.model.message.header.UpnpHeader;
import org.teleal.cling.model.types.UDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class USNRootDeviceHeader
extends UpnpHeader<UDN> {
    public static final String ROOT_DEVICE_SUFFIX = "::upnp:rootdevice";

    public USNRootDeviceHeader() {
    }

    public USNRootDeviceHeader(UDN udn) {
        this.setValue(udn);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        if (!s.startsWith("uuid:") || !s.endsWith(ROOT_DEVICE_SUFFIX)) {
            throw new InvalidHeaderException("Invalid root device USN header value, must start with 'uuid:' and end with '::upnp:rootdevice' but is '" + s + "'");
        }
        UDN udn = new UDN(s.substring("uuid:".length(), s.length() - ROOT_DEVICE_SUFFIX.length()));
        this.setValue(udn);
    }

    @Override
    public String getString() {
        return ((UDN)this.getValue()).toString() + ROOT_DEVICE_SUFFIX;
    }
}

