/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.message.header;

import org.teleal.cling.model.message.header.InvalidHeaderException;
import org.teleal.cling.model.message.header.UpnpHeader;
import org.teleal.cling.model.types.UDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDNHeader
extends UpnpHeader<UDN> {
    public UDNHeader() {
    }

    public UDNHeader(UDN udn) {
        this.setValue(udn);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        if (!s.startsWith("uuid:")) {
            throw new InvalidHeaderException("Invalid UDA header value, must start with 'uuid:': " + s);
        }
        if (s.contains("::urn")) {
            throw new InvalidHeaderException("Invalid UDA header value, must not contain '::urn': " + s);
        }
        UDN udn = new UDN(s.substring("uuid:".length()));
        this.setValue(udn);
    }

    @Override
    public String getString() {
        return ((UDN)this.getValue()).toString();
    }
}

