/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.message.header;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teleal.cling.model.message.header.InvalidHeaderException;
import org.teleal.cling.model.message.header.UpnpHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeoutHeader
extends UpnpHeader<Integer> {
    public static final Integer INFINITE_VALUE = Integer.MAX_VALUE;
    public static final Pattern PATTERN = Pattern.compile("Second-(?:([0-9]+)|infinite)");

    public TimeoutHeader() {
        this.setValue(1800);
    }

    public TimeoutHeader(int timeoutSeconds) {
        this.setValue(timeoutSeconds);
    }

    public TimeoutHeader(Integer timeoutSeconds) {
        this.setValue(timeoutSeconds);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        Matcher matcher = PATTERN.matcher(s);
        if (!matcher.matches()) {
            throw new InvalidHeaderException("Can't parse timeout seconds integer from: " + s);
        }
        if (matcher.group(1) != null) {
            this.setValue(Integer.parseInt(matcher.group(1)));
        } else {
            this.setValue(INFINITE_VALUE);
        }
    }

    @Override
    public String getString() {
        return "Second-" + (((Integer)this.getValue()).equals(INFINITE_VALUE) ? "infinite" : (Serializable)this.getValue());
    }
}

