/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.message.header;

import java.net.URI;
import org.teleal.cling.model.message.header.InvalidHeaderException;
import org.teleal.cling.model.message.header.UpnpHeader;
import org.teleal.cling.model.types.SoapActionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapActionHeader
extends UpnpHeader<SoapActionType> {
    public SoapActionHeader() {
    }

    public SoapActionHeader(URI uri) {
        this.setValue(SoapActionType.valueOf(uri.toString()));
    }

    public SoapActionHeader(SoapActionType value) {
        this.setValue(value);
    }

    public SoapActionHeader(String s) throws InvalidHeaderException {
        this.setString(s);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        try {
            if (!s.startsWith("\"") && s.endsWith("\"")) {
                throw new InvalidHeaderException("Invalid SOAP action header, must be enclosed in doublequotes:" + s);
            }
            SoapActionType t = SoapActionType.valueOf(s.substring(1, s.length() - 1));
            this.setValue(t);
        }
        catch (RuntimeException ex) {
            throw new InvalidHeaderException("Invalid SOAP action header value, " + ex.getMessage());
        }
    }

    @Override
    public String getString() {
        return "\"" + ((SoapActionType)this.getValue()).toString() + "\"";
    }
}

