/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.message.header;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teleal.cling.model.message.header.InvalidHeaderException;
import org.teleal.cling.model.message.header.UpnpHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxAgeHeader
extends UpnpHeader<Integer> {
    public static final Pattern MAX_AGE_REGEX = Pattern.compile(".*max-age\\s*=\\s*([0-9]+).*");

    public MaxAgeHeader(Integer maxAge) {
        this.setValue(maxAge);
    }

    public MaxAgeHeader() {
        this.setValue(1800);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        Matcher matcher = MAX_AGE_REGEX.matcher(s.toLowerCase());
        if (!matcher.matches()) {
            throw new InvalidHeaderException("Invalid cache-control value, can't parse max-age seconds: " + s);
        }
        Integer maxAge = Integer.parseInt(matcher.group(1));
        this.setValue(maxAge);
    }

    @Override
    public String getString() {
        return "max-age=" + ((Integer)this.getValue()).toString();
    }
}

