/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.message.header;

import org.teleal.cling.model.message.header.InvalidHeaderException;
import org.teleal.cling.model.message.header.UpnpHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MXHeader
extends UpnpHeader<Integer> {
    public static final Integer DEFAULT_VALUE = 3;

    public MXHeader() {
        this.setValue(DEFAULT_VALUE);
    }

    public MXHeader(Integer delayInSeconds) {
        this.setValue(delayInSeconds);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        Integer value;
        try {
            value = Integer.parseInt(s);
        }
        catch (Exception ex) {
            throw new InvalidHeaderException("Can't parse MX seconds integer from: " + s);
        }
        if (value < 0 || value > 120) {
            this.setValue(DEFAULT_VALUE);
        } else {
            this.setValue(value);
        }
    }

    @Override
    public String getString() {
        return ((Integer)this.getValue()).toString();
    }
}

