/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.message.header;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teleal.cling.model.message.header.InvalidHeaderException;
import org.teleal.cling.model.message.header.UpnpHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MANHeader
extends UpnpHeader<String> {
    public static final Pattern PATTERN = Pattern.compile("\"(.+?)\"(;.+?)??");
    public static final Pattern NAMESPACE_PATTERN = Pattern.compile(";\\s?ns\\s?=\\s?([0-9]{2})");
    public String namespace;

    public MANHeader() {
    }

    public MANHeader(String value) {
        this.setValue(value);
    }

    public MANHeader(String value, String namespace) {
        this(value);
        this.namespace = namespace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setString(String s) throws InvalidHeaderException {
        Matcher matcher = PATTERN.matcher(s);
        if (!matcher.matches()) throw new InvalidHeaderException("Invalid MAN header value: " + s);
        this.setValue(matcher.group(1));
        if (matcher.group(2) == null) return;
        Matcher nsMatcher = NAMESPACE_PATTERN.matcher(matcher.group(2));
        if (!nsMatcher.matches()) throw new InvalidHeaderException("Invalid namespace in MAN header value: " + s);
        this.setNamespace(nsMatcher.group(1));
    }

    @Override
    public String getString() {
        if (this.getValue() == null) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append("\"").append((String)this.getValue()).append("\"");
        if (this.getNamespace() != null) {
            s.append("; ns=").append(this.getNamespace());
        }
        return s.toString();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }
}

