/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.message.header;

import org.teleal.cling.model.message.header.InvalidHeaderException;
import org.teleal.cling.model.message.header.UpnpHeader;
import org.teleal.cling.model.types.DeviceType;
import org.teleal.cling.model.types.NamedDeviceType;
import org.teleal.cling.model.types.UDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceUSNHeader
extends UpnpHeader<NamedDeviceType> {
    public DeviceUSNHeader() {
    }

    public DeviceUSNHeader(UDN udn, DeviceType deviceType) {
        this.setValue(new NamedDeviceType(udn, deviceType));
    }

    public DeviceUSNHeader(NamedDeviceType value) {
        this.setValue(value);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        try {
            this.setValue(NamedDeviceType.valueOf(s));
        }
        catch (Exception ex) {
            throw new InvalidHeaderException("Invalid device USN header value, " + ex.getMessage());
        }
    }

    @Override
    public String getString() {
        return ((NamedDeviceType)this.getValue()).toString();
    }
}

