/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.message.header;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.teleal.cling.model.message.header.InvalidHeaderException;
import org.teleal.cling.model.message.header.UpnpHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackHeader
extends UpnpHeader<List<URL>> {
    public CallbackHeader() {
        this.setValue(new ArrayList());
    }

    public CallbackHeader(List<URL> urls) {
        this();
        ((List)this.getValue()).addAll(urls);
    }

    public CallbackHeader(URL url) {
        this();
        ((List)this.getValue()).add(url);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        if (s.length() == 0) {
            return;
        }
        if (!s.contains("<") || !s.contains(">")) {
            throw new InvalidHeaderException("URLs not in brackets: " + s);
        }
        s = s.replaceAll("<", "");
        String[] split = s.split(">");
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String sp : split) {
                if (!(sp = sp.trim()).startsWith("http://")) {
                    throw new InvalidHeaderException("Can't parse non-http callback URL: " + sp);
                }
                urls.add(new URL(sp));
            }
            this.setValue(urls);
        }
        catch (MalformedURLException ex) {
            throw new InvalidHeaderException("Can't parse callback URLs from '" + s + "': " + ex);
        }
    }

    @Override
    public String getString() {
        StringBuilder s = new StringBuilder();
        for (URL url : (List)this.getValue()) {
            s.append("<").append(url.toString()).append(">");
        }
        return s.toString();
    }
}

