/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.message.discovery;

import org.teleal.cling.model.Location;
import org.teleal.cling.model.message.discovery.OutgoingNotificationRequest;
import org.teleal.cling.model.message.header.InterfaceMacHeader;
import org.teleal.cling.model.message.header.RootDeviceHeader;
import org.teleal.cling.model.message.header.USNRootDeviceHeader;
import org.teleal.cling.model.message.header.UpnpHeader;
import org.teleal.cling.model.meta.DeviceIdentity;
import org.teleal.cling.model.meta.LocalDevice;
import org.teleal.cling.model.types.NotificationSubtype;

public class OutgoingNotificationRequestRootDevice
extends OutgoingNotificationRequest {
    public OutgoingNotificationRequestRootDevice(Location location, LocalDevice device, NotificationSubtype type) {
        super(location, device, type);
        this.getHeaders().add(UpnpHeader.Type.NT, new RootDeviceHeader());
        this.getHeaders().add(UpnpHeader.Type.USN, new USNRootDeviceHeader(((DeviceIdentity)device.getIdentity()).getUdn()));
        if (location.getNetworkAddress().getHardwareAddress() != null) {
            this.getHeaders().add(UpnpHeader.Type.EXT_IFACE_MAC, new InterfaceMacHeader(location.getNetworkAddress().getHardwareAddress()));
        }
    }
}

