/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.message.control;

import java.net.URL;
import java.util.logging.Logger;
import org.teleal.cling.model.action.ActionInvocation;
import org.teleal.cling.model.message.StreamRequestMessage;
import org.teleal.cling.model.message.UpnpRequest;
import org.teleal.cling.model.message.control.ActionRequestMessage;
import org.teleal.cling.model.message.header.ContentTypeHeader;
import org.teleal.cling.model.message.header.SoapActionHeader;
import org.teleal.cling.model.message.header.UpnpHeader;
import org.teleal.cling.model.meta.Action;
import org.teleal.cling.model.meta.QueryStateVariableAction;
import org.teleal.cling.model.meta.Service;
import org.teleal.cling.model.types.SoapActionType;

public class OutgoingActionRequestMessage
extends StreamRequestMessage
implements ActionRequestMessage {
    private static Logger log = Logger.getLogger(OutgoingActionRequestMessage.class.getName());
    private final String actionNamespace;

    public OutgoingActionRequestMessage(ActionInvocation actionInvocation, URL controlURL) {
        this(actionInvocation.getAction(), new UpnpRequest(UpnpRequest.Method.POST, controlURL));
    }

    public OutgoingActionRequestMessage(Action action, UpnpRequest operation) {
        super(operation);
        SoapActionHeader soapActionHeader;
        this.getHeaders().add(UpnpHeader.Type.CONTENT_TYPE, new ContentTypeHeader(ContentTypeHeader.DEFAULT_CONTENT_TYPE_UTF8));
        if (action instanceof QueryStateVariableAction) {
            log.fine("Adding magic control SOAP action header for state variable query action");
            soapActionHeader = new SoapActionHeader(new SoapActionType("schemas-upnp-org", "control-1-0", null, action.getName()));
        } else {
            soapActionHeader = new SoapActionHeader(new SoapActionType(((Service)action.getService()).getServiceType(), action.getName()));
        }
        this.actionNamespace = ((SoapActionType)soapActionHeader.getValue()).getTypeString();
        if (!((UpnpRequest)this.getOperation()).getMethod().equals((Object)UpnpRequest.Method.POST)) {
            throw new IllegalArgumentException("Can't send action with request method: " + (Object)((Object)((UpnpRequest)this.getOperation()).getMethod()));
        }
        this.getHeaders().add(UpnpHeader.Type.SOAPACTION, soapActionHeader);
        log.fine("Added SOAP action header: " + this.getHeaders().getFirstHeader(UpnpHeader.Type.SOAPACTION).getString());
    }

    public String getActionNamespace() {
        return this.actionNamespace;
    }
}

