/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.gena;

import java.util.LinkedHashMap;
import java.util.Map;
import org.teleal.cling.model.meta.Service;
import org.teleal.cling.model.state.StateVariableValue;
import org.teleal.cling.model.types.UnsignedIntegerFourBytes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GENASubscription<S extends Service> {
    protected S service;
    protected String subscriptionId;
    protected int requestedDurationSeconds = 1800;
    protected int actualDurationSeconds;
    protected UnsignedIntegerFourBytes currentSequence;
    protected Map<String, StateVariableValue<S>> currentValues = new LinkedHashMap<String, StateVariableValue<S>>();

    protected GENASubscription(S service) {
        this.service = service;
    }

    public GENASubscription(S service, int requestedDurationSeconds) {
        this(service);
        this.requestedDurationSeconds = requestedDurationSeconds;
    }

    public synchronized S getService() {
        return this.service;
    }

    public synchronized String getSubscriptionId() {
        return this.subscriptionId;
    }

    public synchronized void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public synchronized int getRequestedDurationSeconds() {
        return this.requestedDurationSeconds;
    }

    public synchronized int getActualDurationSeconds() {
        return this.actualDurationSeconds;
    }

    public synchronized void setActualSubscriptionDurationSeconds(int seconds) {
        this.actualDurationSeconds = seconds;
    }

    public synchronized UnsignedIntegerFourBytes getCurrentSequence() {
        return this.currentSequence;
    }

    public synchronized Map<String, StateVariableValue<S>> getCurrentValues() {
        return this.currentValues;
    }

    public abstract void established();

    public abstract void eventReceived();

    public String toString() {
        return "(GENASubscription, SID: " + this.getSubscriptionId() + ", SEQUENCE: " + this.getCurrentSequence() + ")";
    }
}

