/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model.action;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Logger;
import org.teleal.cling.model.action.AbstractActionExecutor;
import org.teleal.cling.model.action.ActionArgumentValue;
import org.teleal.cling.model.action.ActionException;
import org.teleal.cling.model.action.ActionInvocation;
import org.teleal.cling.model.meta.ActionArgument;
import org.teleal.cling.model.meta.LocalService;
import org.teleal.cling.model.state.StateVariableAccessor;
import org.teleal.cling.model.types.ErrorCode;
import org.teleal.common.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodActionExecutor
extends AbstractActionExecutor {
    private static Logger log = Logger.getLogger(MethodActionExecutor.class.getName());
    protected Method method;

    public MethodActionExecutor(Method method) {
        this.method = method;
    }

    public MethodActionExecutor(Map<ActionArgument<LocalService>, StateVariableAccessor> outputArgumentAccessors, Method method) {
        super(outputArgumentAccessors);
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    protected void execute(ActionInvocation<LocalService> actionInvocation, Object serviceImpl) throws Exception {
        Object result;
        Object[] inputArgumentValues = this.createInputArgumentValues(actionInvocation, this.method);
        if (!actionInvocation.getAction().hasOutputArguments()) {
            log.fine("Calling local service method with no output arguments: " + this.method);
            Reflections.invoke(this.method, serviceImpl, inputArgumentValues);
            return;
        }
        boolean isVoid = this.method.getReturnType().equals(Void.TYPE);
        log.fine("Calling local service method with output arguments: " + this.method);
        boolean isArrayResultProcessed = true;
        if (isVoid) {
            log.fine("Action method is void, calling declared accessors(s) on service instance to retrieve ouput argument(s)");
            Reflections.invoke(this.method, serviceImpl, inputArgumentValues);
            result = this.readOutputArgumentValues(actionInvocation.getAction(), serviceImpl);
        } else if (this.isUseOutputArgumentAccessors(actionInvocation)) {
            log.fine("Action method is not void, calling declared accessor(s) on returned instance to retrieve ouput argument(s)");
            Object returnedInstance = Reflections.invoke(this.method, serviceImpl, inputArgumentValues);
            result = this.readOutputArgumentValues(actionInvocation.getAction(), returnedInstance);
        } else {
            log.fine("Action method is not void, using returned value as (single) output argument");
            result = Reflections.invoke(this.method, serviceImpl, inputArgumentValues);
            isArrayResultProcessed = false;
        }
        ActionArgument<LocalService>[] outputArgs = actionInvocation.getAction().getOutputArguments();
        if (isArrayResultProcessed && result instanceof Object[]) {
            Object[] results = (Object[])result;
            log.fine("Accessors returned Object[], setting output argument values: " + results.length);
            for (int i = 0; i < outputArgs.length; ++i) {
                this.setOutputArgumentValue(actionInvocation, outputArgs[i], results[i]);
            }
        } else if (outputArgs.length == 1) {
            this.setOutputArgumentValue(actionInvocation, outputArgs[0], result);
        } else {
            throw new ActionException(ErrorCode.ACTION_FAILED, "Method return does not match required number of output arguments: " + outputArgs.length);
        }
    }

    protected boolean isUseOutputArgumentAccessors(ActionInvocation<LocalService> actionInvocation) {
        for (ActionArgument<LocalService> argument : actionInvocation.getAction().getOutputArguments()) {
            if (this.getOutputArgumentAccessors().get(argument) == null) continue;
            return true;
        }
        return false;
    }

    protected Object[] createInputArgumentValues(ActionInvocation<LocalService> actionInvocation, Method method) throws ActionException {
        LocalService service = actionInvocation.getAction().getService();
        Object[] values = new Object[actionInvocation.getAction().getInputArguments().length];
        int i = 0;
        for (ActionArgument<LocalService> argument : actionInvocation.getAction().getInputArguments()) {
            Class<?> methodParameterType = method.getParameterTypes()[i];
            ActionArgumentValue<LocalService> inputValue = actionInvocation.getInput(argument);
            if (methodParameterType.isPrimitive() && (inputValue == null || inputValue.toString().length() == 0)) {
                throw new ActionException(ErrorCode.ARGUMENT_VALUE_INVALID, "Primitive action method argument '" + argument.getName() + "' requires input value, can't be null or empty string");
            }
            if (inputValue == null) {
                values[i++] = null;
                continue;
            }
            String inputCallValueString = inputValue.toString();
            if (inputCallValueString.length() > 0 && service.isStringConvertibleType(methodParameterType) && !methodParameterType.isEnum()) {
                try {
                    Constructor<?> ctor = methodParameterType.getConstructor(String.class);
                    log.finer("Creating new input argument value instance with String.class constructor of type: " + methodParameterType);
                    Object o = ctor.newInstance(inputCallValueString);
                    values[i++] = o;
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                    throw new ActionException(ErrorCode.ARGUMENT_VALUE_INVALID, "Can't convert input argment string to desired type of '" + argument.getName() + "': " + ex);
                }
            }
            values[i++] = inputValue.getValue();
        }
        return values;
    }
}

