/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model;

import org.teleal.cling.model.ModelUtil;
import org.teleal.cling.model.types.Datatype;
import org.teleal.cling.model.types.InvalidValueException;

public class VariableValue {
    private final Datatype datatype;
    private final Object value;

    public VariableValue(Datatype datatype, Object value) throws InvalidValueException {
        this.datatype = datatype;
        Object object = this.value = value instanceof String ? datatype.valueOf((String)value) : value;
        if (ModelUtil.ANDROID_RUNTIME) {
            return;
        }
        if (!this.getDatatype().isValid(this.getValue())) {
            throw new InvalidValueException("Invalid value for " + this.getDatatype() + ": " + this.getValue());
        }
        if (!this.isValidXMLString(this.toString())) {
            throw new InvalidValueException("Invalid characters in string value (XML 1.0, section 2.2) produced by " + this.getDatatype() + "");
        }
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public Object getValue() {
        return this.value;
    }

    protected boolean isValidXMLString(String s) {
        int cp;
        for (int i = 0; i < s.length(); i += Character.charCount(cp)) {
            cp = s.codePointAt(i);
            if (cp == 9 || cp == 10 || cp == 13 || cp >= 32 && cp <= 55295 || cp >= 57344 && cp <= 65533 || cp >= 65536 && cp <= 0x10FFFF) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getDatatype().getString(this.getValue());
    }
}

