/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import org.teleal.cling.model.ValidationError;
import org.teleal.cling.model.ValidationException;
import org.teleal.cling.model.meta.Device;
import org.teleal.cling.model.meta.DeviceIdentity;
import org.teleal.cling.model.meta.Service;
import org.teleal.cling.model.resource.Resource;
import org.teleal.common.util.URIUtil;

public class Namespace {
    private static final Logger log = Logger.getLogger(Namespace.class.getName());
    public static final String DEVICE = "/dev";
    public static final String SERVICE = "/svc";
    public static final String CONTROL = "/action";
    public static final String EVENTS = "/event";
    public static final String DESCRIPTOR_FILE = "/desc.xml";
    public static final String CALLBACK_FILE = "/cb.xml";
    protected final URI basePath;

    public Namespace() {
        this.basePath = URI.create("");
    }

    public Namespace(String basePath) {
        this(URI.create(basePath));
    }

    public Namespace(URI basePath) {
        this.basePath = basePath;
    }

    public URI getBasePath() {
        return this.basePath;
    }

    public URI getPath(Device device) {
        if (((DeviceIdentity)device.getIdentity()).getUdn() == null) {
            throw new IllegalStateException("Can't generate local URI prefix without UDN");
        }
        StringBuilder s = new StringBuilder();
        s.append(DEVICE).append("/");
        s.append(URIUtil.encodePathSegment(((DeviceIdentity)device.getIdentity()).getUdn().getIdentifierString()));
        return URI.create(this.getBasePath().toString() + s.toString());
    }

    public URI getPath(Service service) {
        if (service.getServiceId() == null) {
            throw new IllegalStateException("Can't generate local URI prefix without service ID");
        }
        StringBuilder s = new StringBuilder();
        s.append(SERVICE);
        s.append("/");
        s.append(service.getServiceId().getNamespace());
        s.append("/");
        s.append(service.getServiceId().getId());
        return URI.create(this.getPath((Device)service.getDevice()).toString() + s.toString());
    }

    public URI getDescriptorPath(Device device) {
        return URI.create(this.getPath((Device)device.getRoot()).toString() + DESCRIPTOR_FILE);
    }

    public URI getDescriptorPath(Service service) {
        return URI.create(this.getPath(service).toString() + DESCRIPTOR_FILE);
    }

    public URI getControlPath(Service service) {
        return URI.create(this.getPath(service).toString() + CONTROL);
    }

    public URI getEventSubscriptionPath(Service service) {
        return URI.create(this.getPath(service).toString() + EVENTS);
    }

    public URI getEventCallbackPath(Service service) {
        return URI.create(this.getEventSubscriptionPath(service).toString() + CALLBACK_FILE);
    }

    public URI prefixIfRelative(Device device, URI uri) {
        if (!uri.isAbsolute() && !uri.getPath().startsWith("/")) {
            return URI.create(this.getPath(device).toString() + "/" + uri.toString());
        }
        return uri;
    }

    public boolean isControlPath(URI uri) {
        return uri.toString().endsWith(CONTROL);
    }

    public boolean isEventSubscriptionPath(URI uri) {
        return uri.toString().endsWith(EVENTS);
    }

    public boolean isEventCallbackPath(URI uri) {
        return uri.toString().endsWith(CALLBACK_FILE);
    }

    public Resource[] getResources(Device device) throws ValidationException {
        Resource[] discoveredResources;
        if (!device.isRoot()) {
            return null;
        }
        HashSet<Resource> resources = new HashSet<Resource>();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        log.fine("Discovering local resources of device graph");
        for (Resource resource : discoveredResources = device.discoverResources(this)) {
            log.finer("Discovered: " + resource);
            if (resources.add(resource)) continue;
            log.finer("Local resource already exists, queueing validation error");
            errors.add(new ValidationError(this.getClass(), "resources", "Local URI namespace conflict between resources of device: " + resource));
        }
        if (errors.size() > 0) {
            throw new ValidationException("Validation of device graph failed, call getErrors() on exception", errors);
        }
        return resources.toArray(new Resource[resources.size()]);
    }
}

