/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model;

import java.net.URI;
import java.net.URL;
import org.teleal.cling.model.NetworkAddress;
import org.teleal.common.util.URIUtil;

public class Location {
    protected NetworkAddress networkAddress;
    protected URI path;

    public Location(NetworkAddress networkAddress, URI path) {
        this.networkAddress = networkAddress;
        this.path = path;
    }

    public NetworkAddress getNetworkAddress() {
        return this.networkAddress;
    }

    public URI getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        if (!this.networkAddress.equals(location.networkAddress)) {
            return false;
        }
        return this.path.equals(location.path);
    }

    public int hashCode() {
        int result = this.networkAddress.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }

    public URL getURL() {
        return URIUtil.createAbsoluteURL(this.networkAddress.getAddress(), this.networkAddress.getPort(), this.path);
    }
}

