/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model;

import java.util.Date;

public class ExpirationDetails {
    public static final int UNLIMITED_AGE = 0;
    private int maxAgeSeconds = 0;
    private long lastRefreshTimestampSeconds = this.getCurrentTimestampSeconds();
    private static String simpleName = ExpirationDetails.class.getSimpleName();

    public ExpirationDetails() {
    }

    public ExpirationDetails(int maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds;
    }

    public int getMaxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public long getLastRefreshTimestampSeconds() {
        return this.lastRefreshTimestampSeconds;
    }

    public void setLastRefreshTimestampSeconds(long lastRefreshTimestampSeconds) {
        this.lastRefreshTimestampSeconds = lastRefreshTimestampSeconds;
    }

    public void stampLastRefresh() {
        this.setLastRefreshTimestampSeconds(this.getCurrentTimestampSeconds());
    }

    public boolean hasExpired() {
        return this.hasExpired(false);
    }

    public boolean hasExpired(boolean halfTime) {
        return this.maxAgeSeconds != 0 && this.lastRefreshTimestampSeconds + (long)(this.maxAgeSeconds / (halfTime ? 2 : 1)) < this.getCurrentTimestampSeconds();
    }

    public long getSecondsUntilExpiration() {
        return this.maxAgeSeconds == 0 ? Integer.MAX_VALUE : this.lastRefreshTimestampSeconds + (long)this.maxAgeSeconds - this.getCurrentTimestampSeconds();
    }

    protected long getCurrentTimestampSeconds() {
        return new Date().getTime() / 1000L;
    }

    public String toString() {
        return "(" + simpleName + ")" + " MAX AGE: " + this.maxAgeSeconds;
    }
}

