/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.teleal.cling.model.Command;
import org.teleal.cling.model.ServiceManager;
import org.teleal.cling.model.meta.LocalService;
import org.teleal.cling.model.meta.StateVariable;
import org.teleal.cling.model.state.StateVariableAccessor;
import org.teleal.cling.model.state.StateVariableValue;
import org.teleal.common.util.Exceptions;
import org.teleal.common.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServiceManager<T>
implements ServiceManager<T> {
    private static Logger log = Logger.getLogger(DefaultServiceManager.class.getName());
    protected final LocalService<T> service;
    protected final Class<T> serviceClass;
    protected final ReentrantLock lock = new ReentrantLock(true);
    protected T serviceImpl;
    protected PropertyChangeSupport propertyChangeSupport;

    protected DefaultServiceManager(LocalService<T> service) {
        this(service, null);
    }

    public DefaultServiceManager(LocalService<T> service, Class<T> serviceClass) {
        this.service = service;
        this.serviceClass = serviceClass;
    }

    protected void lock() {
        try {
            if (!this.lock.tryLock(this.getLockTimeoutMillis(), TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Failed to acquire lock in milliseconds: " + this.getLockTimeoutMillis());
            }
            log.fine("Acquired lock");
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to acquire lock:" + e);
        }
    }

    protected void unlock() {
        log.fine("Releasing lock");
        this.lock.unlock();
    }

    protected int getLockTimeoutMillis() {
        return 500;
    }

    @Override
    public LocalService<T> getService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getImplementation() {
        this.lock();
        try {
            if (this.serviceImpl == null) {
                this.init();
            }
            T t = this.serviceImpl;
            return t;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        this.lock();
        try {
            if (this.propertyChangeSupport == null) {
                this.init();
            }
            PropertyChangeSupport propertyChangeSupport = this.propertyChangeSupport;
            return propertyChangeSupport;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Command<T> cmd) throws Exception {
        this.lock();
        try {
            cmd.execute(this);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<StateVariableValue> readEventedStateVariableValues() throws Exception {
        this.lock();
        try {
            ArrayList<StateVariableValue> values = new ArrayList<StateVariableValue>();
            for (StateVariable<LocalService> stateVariable : this.getService().getStateVariables()) {
                if (!stateVariable.getEventDetails().isSendEvents()) continue;
                StateVariableAccessor accessor = this.getService().getAccessor(stateVariable);
                if (accessor == null) {
                    throw new IllegalStateException("No accessor for evented state variable");
                }
                values.add(accessor.read(stateVariable, this.getImplementation()));
            }
            ArrayList<StateVariableValue> arrayList = values;
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    protected void init() {
        log.fine("No service implementation instance available, initializing...");
        try {
            this.serviceImpl = this.createServiceInstance();
            this.propertyChangeSupport = this.createPropertyChangeSupport(this.serviceImpl);
            this.propertyChangeSupport.addPropertyChangeListener(this.createPropertyChangeListener(this.serviceImpl));
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not initialize implementation: " + ex, ex);
        }
    }

    protected T createServiceInstance() throws Exception {
        if (this.serviceClass == null) {
            throw new IllegalStateException("Subclass has to provide service class or override createServiceInstance()");
        }
        try {
            return this.serviceClass.getConstructor(LocalService.class).newInstance(this.getService());
        }
        catch (NoSuchMethodException ex) {
            log.fine("Creating new service implementation instance with no-arg constructor: " + this.serviceClass.getName());
            return this.serviceClass.newInstance();
        }
    }

    protected PropertyChangeSupport createPropertyChangeSupport(T serviceImpl) throws Exception {
        Method m = Reflections.getGetterMethod(serviceImpl.getClass(), "propertyChangeSupport");
        if (m != null && PropertyChangeSupport.class.isAssignableFrom(m.getReturnType())) {
            log.fine("Service implementation instance offers PropertyChangeSupport, using that: " + serviceImpl.getClass().getName());
            return (PropertyChangeSupport)m.invoke(serviceImpl, new Object[0]);
        }
        log.fine("Creating new PropertyChangeSupport for service implementation: " + serviceImpl.getClass().getName());
        return new PropertyChangeSupport(serviceImpl);
    }

    protected PropertyChangeListener createPropertyChangeListener(T serviceImpl) throws Exception {
        return new DefaultPropertyChangeListener();
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") Implementation: " + this.serviceImpl;
    }

    protected class DefaultPropertyChangeListener
    implements PropertyChangeListener {
        protected DefaultPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            log.finer("Property change event on local service: " + e.getPropertyName());
            if (e.getPropertyName().equals("_EventedStateVariables")) {
                return;
            }
            StateVariable sv = DefaultServiceManager.this.getService().getStateVariable(e.getPropertyName());
            if (sv == null || !sv.getEventDetails().isSendEvents()) {
                return;
            }
            try {
                log.fine("Evented state variable value changed, reading state of service: " + sv);
                Collection<StateVariableValue> currentValues = DefaultServiceManager.this.readEventedStateVariableValues();
                DefaultServiceManager.this.getPropertyChangeSupport().firePropertyChange("_EventedStateVariables", null, currentValues);
            }
            catch (Exception ex) {
                log.severe("Error reading state of service after state variable update event: " + Exceptions.unwrap(ex));
            }
        }
    }
}

