/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.mock;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import org.teleal.cling.DefaultUpnpServiceConfiguration;
import org.teleal.cling.UpnpService;
import org.teleal.cling.UpnpServiceConfiguration;
import org.teleal.cling.controlpoint.ControlPoint;
import org.teleal.cling.controlpoint.ControlPointImpl;
import org.teleal.cling.model.NetworkAddress;
import org.teleal.cling.model.message.IncomingDatagramMessage;
import org.teleal.cling.model.message.OutgoingDatagramMessage;
import org.teleal.cling.model.message.StreamRequestMessage;
import org.teleal.cling.model.message.StreamResponseMessage;
import org.teleal.cling.model.message.header.UpnpHeader;
import org.teleal.cling.model.meta.LocalDevice;
import org.teleal.cling.protocol.ProtocolFactory;
import org.teleal.cling.protocol.ProtocolFactoryImpl;
import org.teleal.cling.protocol.async.SendingNotificationAlive;
import org.teleal.cling.protocol.async.SendingSearch;
import org.teleal.cling.registry.Registry;
import org.teleal.cling.registry.RegistryImpl;
import org.teleal.cling.registry.RegistryMaintainer;
import org.teleal.cling.transport.Router;
import org.teleal.cling.transport.impl.NetworkAddressFactoryImpl;
import org.teleal.cling.transport.spi.NetworkAddressFactory;
import org.teleal.cling.transport.spi.StreamClient;
import org.teleal.cling.transport.spi.UpnpStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockUpnpService
implements UpnpService {
    protected final UpnpServiceConfiguration configuration;
    protected final ControlPoint controlPoint;
    protected final ProtocolFactory protocolFactory;
    protected final Registry registry;
    protected final Router router;
    protected final NetworkAddressFactory networkAddressFactory;
    private List<IncomingDatagramMessage> incomingDatagramMessages = new ArrayList<IncomingDatagramMessage>();
    private List<OutgoingDatagramMessage> outgoingDatagramMessages = new ArrayList<OutgoingDatagramMessage>();
    private List<UpnpStream> receivedUpnpStreams = new ArrayList<UpnpStream>();
    private List<StreamRequestMessage> sentStreamRequestMessages = new ArrayList<StreamRequestMessage>();
    private List<byte[]> broadcastedBytes = new ArrayList<byte[]>();

    public MockUpnpService() {
        this(false, false, false);
    }

    public MockUpnpService(boolean sendsAlive, boolean maintainsRegistry) {
        this(sendsAlive, maintainsRegistry, false);
    }

    public MockUpnpService(boolean sendsAlive, final boolean maintainsRegistry, final boolean multiThreaded) {
        this.configuration = new DefaultUpnpServiceConfiguration(false){

            protected NetworkAddressFactory createNetworkAddressFactory(int streamListenPort) {
                return new NetworkAddressFactoryImpl(streamListenPort){

                    protected boolean isUsableNetworkInterface(NetworkInterface iface) throws Exception {
                        return iface.isLoopback();
                    }

                    protected boolean isUsableAddress(NetworkInterface networkInterface, InetAddress address) {
                        return address.isLoopbackAddress() && address instanceof Inet4Address;
                    }
                };
            }

            public Executor getRegistryMaintainerExecutor() {
                if (maintainsRegistry) {
                    return new Executor(){

                        public void execute(Runnable runnable) {
                            new Thread(runnable).start();
                        }
                    };
                }
                return this.createDefaultExecutor();
            }

            protected Executor createDefaultExecutor() {
                return multiThreaded ? super.createDefaultExecutor() : new Executor(){

                    public void execute(Runnable runnable) {
                        runnable.run();
                    }
                };
            }
        };
        this.protocolFactory = this.createProtocolFactory(this, sendsAlive);
        this.registry = new RegistryImpl(this){

            protected RegistryMaintainer createRegistryMaintainer() {
                return maintainsRegistry ? super.createRegistryMaintainer() : null;
            }
        };
        this.networkAddressFactory = this.configuration.createNetworkAddressFactory();
        this.router = this.createRouter();
        this.controlPoint = new ControlPointImpl(this.configuration, this.protocolFactory, this.registry);
    }

    protected ProtocolFactory createProtocolFactory(UpnpService service, boolean sendsAlive) {
        return new MockProtocolFactory(service, sendsAlive);
    }

    protected Router createRouter() {
        return new MockRouter();
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public Router getRouter() {
        return this.router;
    }

    @Override
    public void shutdown() {
        this.getRouter().shutdown();
        this.getRegistry().shutdown();
        this.getConfiguration().shutdown();
    }

    public List<IncomingDatagramMessage> getIncomingDatagramMessages() {
        return this.incomingDatagramMessages;
    }

    public List<OutgoingDatagramMessage> getOutgoingDatagramMessages() {
        return this.outgoingDatagramMessages;
    }

    public List<UpnpStream> getReceivedUpnpStreams() {
        return this.receivedUpnpStreams;
    }

    public List<StreamRequestMessage> getSentStreamRequestMessages() {
        return this.sentStreamRequestMessages;
    }

    public List<byte[]> getBroadcastedBytes() {
        return this.broadcastedBytes;
    }

    public StreamResponseMessage[] getStreamResponseMessages() {
        return null;
    }

    public StreamResponseMessage getStreamResponseMessage(StreamRequestMessage request) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MockRouter
    implements Router {
        int counter = -1;

        @Override
        public UpnpServiceConfiguration getConfiguration() {
            return MockUpnpService.this.configuration;
        }

        @Override
        public ProtocolFactory getProtocolFactory() {
            return MockUpnpService.this.protocolFactory;
        }

        public StreamClient getStreamClient() {
            return null;
        }

        @Override
        public NetworkAddressFactory getNetworkAddressFactory() {
            return MockUpnpService.this.networkAddressFactory;
        }

        @Override
        public List<NetworkAddress> getActiveStreamServers(InetAddress preferredAddress) {
            try {
                return Arrays.asList(new NetworkAddress(InetAddress.getByName("127.0.0.1"), 0));
            }
            catch (UnknownHostException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void shutdown() {
        }

        @Override
        public void received(IncomingDatagramMessage msg) {
            MockUpnpService.this.incomingDatagramMessages.add(msg);
        }

        @Override
        public void received(UpnpStream stream) {
            MockUpnpService.this.receivedUpnpStreams.add(stream);
        }

        @Override
        public void send(OutgoingDatagramMessage msg) {
            MockUpnpService.this.outgoingDatagramMessages.add(msg);
        }

        @Override
        public StreamResponseMessage send(StreamRequestMessage msg) {
            MockUpnpService.this.sentStreamRequestMessages.add(msg);
            ++this.counter;
            return MockUpnpService.this.getStreamResponseMessages() != null ? MockUpnpService.this.getStreamResponseMessages()[this.counter] : MockUpnpService.this.getStreamResponseMessage(msg);
        }

        @Override
        public void broadcast(byte[] bytes) {
            MockUpnpService.this.broadcastedBytes.add(bytes);
        }
    }

    public static class MockProtocolFactory
    extends ProtocolFactoryImpl {
        private boolean sendsAlive;

        public MockProtocolFactory(UpnpService upnpService, boolean sendsAlive) {
            super(upnpService);
            this.sendsAlive = sendsAlive;
        }

        public SendingNotificationAlive createSendingNotificationAlive(LocalDevice localDevice) {
            return new SendingNotificationAlive(this.getUpnpService(), localDevice){

                protected void execute() {
                    if (MockProtocolFactory.this.sendsAlive) {
                        super.execute();
                    }
                }
            };
        }

        public SendingSearch createSendingSearch(UpnpHeader searchTarget, int mxSeconds) {
            return new SendingSearch(this.getUpnpService(), searchTarget, mxSeconds){

                public int getBulkIntervalMilliseconds() {
                    return 0;
                }
            };
        }
    }
}

