/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.controlpoint;

import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.teleal.cling.controlpoint.ControlPoint;
import org.teleal.cling.model.gena.CancelReason;
import org.teleal.cling.model.gena.GENASubscription;
import org.teleal.cling.model.gena.LocalGENASubscription;
import org.teleal.cling.model.gena.RemoteGENASubscription;
import org.teleal.cling.model.message.UpnpResponse;
import org.teleal.cling.model.meta.Device;
import org.teleal.cling.model.meta.DeviceIdentity;
import org.teleal.cling.model.meta.LocalService;
import org.teleal.cling.model.meta.RemoteService;
import org.teleal.cling.model.meta.Service;
import org.teleal.common.util.Exceptions;

public abstract class SubscriptionCallback
implements Runnable {
    protected static Logger log = Logger.getLogger(SubscriptionCallback.class.getName());
    protected final Service service;
    protected final Integer requestedDurationSeconds;
    private ControlPoint controlPoint;
    private GENASubscription subscription;

    protected SubscriptionCallback(Service service) {
        this.service = service;
        this.requestedDurationSeconds = 1800;
    }

    protected SubscriptionCallback(Service service, int requestedDurationSeconds) {
        this.service = service;
        this.requestedDurationSeconds = requestedDurationSeconds;
    }

    public Service getService() {
        return this.service;
    }

    public synchronized ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    public synchronized void setControlPoint(ControlPoint controlPoint) {
        this.controlPoint = controlPoint;
    }

    public synchronized GENASubscription getSubscription() {
        return this.subscription;
    }

    public synchronized void setSubscription(GENASubscription subscription) {
        this.subscription = subscription;
    }

    public synchronized void run() {
        if (this.getControlPoint() == null) {
            throw new IllegalStateException("Callback must be executed through ControlPoint");
        }
        if (this.getService() instanceof LocalService) {
            this.establishLocalSubscription((LocalService)this.service);
        } else if (this.getService() instanceof RemoteService) {
            this.establishRemoteSubscription((RemoteService)this.service);
        }
    }

    private void establishLocalSubscription(LocalService service) {
        if (this.getControlPoint().getRegistry().getLocalDevice(((DeviceIdentity)((Device)service.getDevice()).getIdentity()).getUdn(), false) == null) {
            log.fine("Local device service is currently not registered, failing subscription immediately");
            this.failed(null, null, new IllegalStateException("Local device is not registered"));
            return;
        }
        LocalGENASubscription localSubscription = null;
        try {
            localSubscription = new LocalGENASubscription(service, Integer.MAX_VALUE, Collections.EMPTY_LIST){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void failed(Exception ex) {
                    SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                    synchronized (subscriptionCallback) {
                        SubscriptionCallback.this.setSubscription(null);
                        SubscriptionCallback.this.failed(null, null, ex);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void established() {
                    SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                    synchronized (subscriptionCallback) {
                        SubscriptionCallback.this.setSubscription(this);
                        SubscriptionCallback.this.established(this);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void ended(CancelReason reason) {
                    SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                    synchronized (subscriptionCallback) {
                        SubscriptionCallback.this.setSubscription(null);
                        SubscriptionCallback.this.ended(this, reason, null);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void eventReceived() {
                    SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                    synchronized (subscriptionCallback) {
                        log.fine("Local service state updated, notifying callback, sequence is: " + this.getCurrentSequence());
                        SubscriptionCallback.this.eventReceived(this);
                        this.incrementSequence();
                    }
                }
            };
            log.fine("Local device service is currently registered, also registering subscription");
            this.getControlPoint().getRegistry().addLocalSubscription(localSubscription);
            log.fine("Notifying subscription callback of local subscription availablity");
            localSubscription.establish();
            log.fine("Simulating first initial event for local subscription callback, sequence: " + localSubscription.getCurrentSequence());
            this.eventReceived(localSubscription);
            localSubscription.incrementSequence();
            log.fine("Starting to monitor state changes of local service");
            localSubscription.registerOnService();
        }
        catch (Exception ex) {
            log.fine("Local callback creation failed: " + ex.toString());
            log.log(Level.FINE, "Exception root cause: ", Exceptions.unwrap(ex));
            if (localSubscription != null) {
                this.getControlPoint().getRegistry().removeLocalSubscription(localSubscription);
            }
            this.failed(localSubscription, null, ex);
        }
    }

    private void establishRemoteSubscription(RemoteService service) {
        RemoteGENASubscription remoteSubscription = new RemoteGENASubscription(service, this.requestedDurationSeconds){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void failed(UpnpResponse responseStatus) {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.setSubscription(null);
                    SubscriptionCallback.this.failed(this, responseStatus, null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void established() {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.setSubscription(this);
                    SubscriptionCallback.this.established(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void ended(CancelReason reason, UpnpResponse responseStatus) {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.setSubscription(null);
                    SubscriptionCallback.this.ended(this, reason, responseStatus);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void eventReceived() {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.eventReceived(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void eventsMissed(int numberOfMissedEvents) {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.eventsMissed(this, numberOfMissedEvents);
                }
            }
        };
        this.getControlPoint().getProtocolFactory().createSendingSubscribe(remoteSubscription).run();
    }

    public synchronized void end() {
        if (this.subscription == null) {
            return;
        }
        if (this.subscription instanceof LocalGENASubscription) {
            this.endLocalSubscription((LocalGENASubscription)this.subscription);
        } else if (this.subscription instanceof RemoteGENASubscription) {
            this.endRemoteSubscription((RemoteGENASubscription)this.subscription);
        }
    }

    private void endLocalSubscription(LocalGENASubscription subscription) {
        log.fine("Removing local subscription and ending it in callback: " + subscription);
        this.getControlPoint().getRegistry().removeLocalSubscription(subscription);
        subscription.end(null);
    }

    private void endRemoteSubscription(RemoteGENASubscription subscription) {
        log.fine("Ending remote subscription: " + subscription);
        this.getControlPoint().getConfiguration().getSyncProtocolExecutor().execute(this.getControlPoint().getProtocolFactory().createSendingUnsubscribe(subscription));
    }

    protected void failed(GENASubscription subscription, UpnpResponse responseStatus, Exception exception) {
        this.failed(subscription, responseStatus, exception, SubscriptionCallback.createDefaultFailureMessage(responseStatus, exception));
    }

    protected abstract void failed(GENASubscription var1, UpnpResponse var2, Exception var3, String var4);

    protected abstract void established(GENASubscription var1);

    protected abstract void ended(GENASubscription var1, CancelReason var2, UpnpResponse var3);

    protected abstract void eventReceived(GENASubscription var1);

    protected abstract void eventsMissed(GENASubscription var1, int var2);

    public static String createDefaultFailureMessage(UpnpResponse responseStatus, Exception exception) {
        String message = "Subscription failed: ";
        message = responseStatus != null ? message + " HTTP response was: " + responseStatus.getResponseDetails() : (exception != null ? message + " Exception occured: " + exception : message + " No response received.");
        return message;
    }

    public String toString() {
        return "(SubscriptionCallback) " + this.getService();
    }
}

