/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.controlpoint;

import java.net.URL;
import org.teleal.cling.controlpoint.ControlPoint;
import org.teleal.cling.model.action.ActionException;
import org.teleal.cling.model.action.ActionInvocation;
import org.teleal.cling.model.message.UpnpResponse;
import org.teleal.cling.model.message.control.IncomingActionResponseMessage;
import org.teleal.cling.model.meta.LocalService;
import org.teleal.cling.model.meta.RemoteDevice;
import org.teleal.cling.model.meta.RemoteService;
import org.teleal.cling.protocol.sync.SendingAction;

public abstract class ActionCallback
implements Runnable {
    protected final ActionInvocation actionInvocation;
    protected ControlPoint controlPoint;

    protected ActionCallback(ActionInvocation actionInvocation, ControlPoint controlPoint) {
        this.actionInvocation = actionInvocation;
        this.controlPoint = controlPoint;
    }

    protected ActionCallback(ActionInvocation actionInvocation) {
        this.actionInvocation = actionInvocation;
    }

    public ActionInvocation getActionInvocation() {
        return this.actionInvocation;
    }

    public synchronized ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    public synchronized ActionCallback setControlPoint(ControlPoint controlPoint) {
        this.controlPoint = controlPoint;
        return this;
    }

    public void run() {
        Object service = this.actionInvocation.getAction().getService();
        if (service instanceof LocalService) {
            LocalService localService = (LocalService)service;
            localService.getExecutor(this.actionInvocation.getAction()).execute(this.actionInvocation);
            if (this.actionInvocation.getFailure() != null) {
                this.failure(this.actionInvocation, null);
            } else {
                this.success(this.actionInvocation);
            }
        } else if (service instanceof RemoteService) {
            if (this.getControlPoint() == null) {
                throw new IllegalStateException("Callback must be executed through ControlPoint");
            }
            RemoteService remoteService = (RemoteService)service;
            URL controLURL = ((RemoteDevice)remoteService.getDevice()).normalizeURI(remoteService.getControlURI());
            SendingAction prot = this.getControlPoint().getProtocolFactory().createSendingAction(this.actionInvocation, controLURL);
            prot.run();
            IncomingActionResponseMessage response = (IncomingActionResponseMessage)prot.getOutputMessage();
            if (response == null) {
                this.failure(this.actionInvocation, null);
            } else if (((UpnpResponse)response.getOperation()).isFailed()) {
                this.failure(this.actionInvocation, (UpnpResponse)response.getOperation());
            } else {
                this.success(this.actionInvocation);
            }
        }
    }

    protected String createDefaultFailureMessage(ActionInvocation invocation, UpnpResponse operation) {
        String message = "Error: ";
        ActionException exception = invocation.getFailure();
        if (exception != null) {
            message = message + exception.getMessage();
        }
        if (operation != null) {
            message = message + " (HTTP response was: " + operation.getResponseDetails() + ")";
        }
        return message;
    }

    protected void failure(ActionInvocation invocation, UpnpResponse operation) {
        this.failure(invocation, operation, this.createDefaultFailureMessage(invocation, operation));
    }

    public abstract void success(ActionInvocation var1);

    public abstract void failure(ActionInvocation var1, UpnpResponse var2, String var3);

    public String toString() {
        return "(ActionCallback) " + this.actionInvocation;
    }

    public static final class Default
    extends ActionCallback {
        public Default(ActionInvocation actionInvocation, ControlPoint controlPoint) {
            super(actionInvocation, controlPoint);
        }

        public void success(ActionInvocation invocation) {
        }

        public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
        }
    }
}

