/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.binding.xml;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.teleal.cling.binding.staging.MutableAction;
import org.teleal.cling.binding.staging.MutableActionArgument;
import org.teleal.cling.binding.staging.MutableAllowedValueRange;
import org.teleal.cling.binding.staging.MutableService;
import org.teleal.cling.binding.staging.MutableStateVariable;
import org.teleal.cling.binding.xml.Descriptor;
import org.teleal.cling.binding.xml.DescriptorBindingException;
import org.teleal.cling.binding.xml.ServiceDescriptorBinder;
import org.teleal.cling.binding.xml.UDA10ServiceDescriptorBinderImpl;
import org.teleal.cling.model.ValidationException;
import org.teleal.cling.model.meta.ActionArgument;
import org.teleal.cling.model.meta.Device;
import org.teleal.cling.model.meta.Service;
import org.teleal.cling.model.meta.StateVariableEventDetails;
import org.teleal.cling.model.types.CustomDatatype;
import org.teleal.cling.model.types.Datatype;
import org.teleal.common.xml.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDA10ServiceDescriptorBinderSAXImpl
extends UDA10ServiceDescriptorBinderImpl {
    private static Logger log = Logger.getLogger(ServiceDescriptorBinder.class.getName());

    @Override
    public <S extends Service> S describe(S undescribedService, String descriptorXml) throws DescriptorBindingException, ValidationException {
        if (descriptorXml == null || descriptorXml.length() == 0) {
            throw new DescriptorBindingException("Null or empty descriptor");
        }
        try {
            log.fine("Reading service from XML descriptor");
            SAXParser parser = new SAXParser();
            MutableService descriptor = new MutableService();
            this.hydrateBasic(descriptor, undescribedService);
            new RootHandler(descriptor, parser);
            parser.parse(new InputSource(new StringReader(descriptorXml.trim())));
            return (S)descriptor.build((Device)undescribedService.getDevice());
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DescriptorBindingException("Could not parse service descriptor: " + ex.toString(), ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ServiceDescriptorHandler<I>
    extends SAXParser.Handler<I> {
        public ServiceDescriptorHandler(I instance) {
            super(instance);
        }

        public ServiceDescriptorHandler(I instance, SAXParser parser) {
            super(instance, parser);
        }

        public ServiceDescriptorHandler(I instance, ServiceDescriptorHandler parent) {
            super(instance, parent);
        }

        public ServiceDescriptorHandler(I instance, SAXParser parser, ServiceDescriptorHandler parent) {
            super(instance, parser, parent);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            Descriptor.Service.ELEMENT el = Descriptor.Service.ELEMENT.valueOrNullOf(localName);
            if (el == null) {
                return;
            }
            this.startElement(el, attributes);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            Descriptor.Service.ELEMENT el = Descriptor.Service.ELEMENT.valueOrNullOf(localName);
            if (el == null) {
                return;
            }
            this.endElement(el);
        }

        @Override
        protected boolean isLastElement(String uri, String localName, String qName) {
            Descriptor.Service.ELEMENT el = Descriptor.Service.ELEMENT.valueOrNullOf(localName);
            return el != null && this.isLastElement(el);
        }

        public void startElement(Descriptor.Service.ELEMENT element, Attributes attributes) throws SAXException {
        }

        public void endElement(Descriptor.Service.ELEMENT element) throws SAXException {
        }

        public boolean isLastElement(Descriptor.Service.ELEMENT element) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AllowedValueRangeHandler
    extends ServiceDescriptorHandler<MutableAllowedValueRange> {
        public static final Descriptor.Service.ELEMENT EL = Descriptor.Service.ELEMENT.allowedValueRange;

        public AllowedValueRangeHandler(MutableAllowedValueRange instance, ServiceDescriptorHandler parent) {
            super(instance, parent);
        }

        @Override
        public void endElement(Descriptor.Service.ELEMENT element) throws SAXException {
            try {
                switch (element) {
                    case minimum: {
                        ((MutableAllowedValueRange)this.getInstance()).minimum = Long.valueOf(this.getCharacters());
                        break;
                    }
                    case maximum: {
                        ((MutableAllowedValueRange)this.getInstance()).maximum = Long.valueOf(this.getCharacters());
                        break;
                    }
                    case step: {
                        ((MutableAllowedValueRange)this.getInstance()).step = Long.valueOf(this.getCharacters());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Service.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AllowedValueListHandler
    extends ServiceDescriptorHandler<List<String>> {
        public static final Descriptor.Service.ELEMENT EL = Descriptor.Service.ELEMENT.allowedValueList;

        public AllowedValueListHandler(List<String> instance, ServiceDescriptorHandler parent) {
            super(instance, parent);
        }

        @Override
        public void endElement(Descriptor.Service.ELEMENT element) throws SAXException {
            switch (element) {
                case allowedValue: {
                    ((List)this.getInstance()).add(this.getCharacters());
                }
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Service.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StateVariableHandler
    extends ServiceDescriptorHandler<MutableStateVariable> {
        public static final Descriptor.Service.ELEMENT EL = Descriptor.Service.ELEMENT.stateVariable;

        public StateVariableHandler(MutableStateVariable instance, ServiceDescriptorHandler parent) {
            super(instance, parent);
        }

        @Override
        public void startElement(Descriptor.Service.ELEMENT element, Attributes attributes) throws SAXException {
            if (element.equals((Object)AllowedValueListHandler.EL)) {
                ArrayList<String> allowedValues = new ArrayList<String>();
                ((MutableStateVariable)this.getInstance()).allowedValues = allowedValues;
                new AllowedValueListHandler((List<String>)allowedValues, (ServiceDescriptorHandler)this);
            }
            if (element.equals((Object)AllowedValueRangeHandler.EL)) {
                MutableAllowedValueRange allowedValueRange;
                ((MutableStateVariable)this.getInstance()).allowedValueRange = allowedValueRange = new MutableAllowedValueRange();
                new AllowedValueRangeHandler(allowedValueRange, (ServiceDescriptorHandler)this);
            }
        }

        @Override
        public void endElement(Descriptor.Service.ELEMENT element) throws SAXException {
            switch (element) {
                case name: {
                    ((MutableStateVariable)this.getInstance()).name = this.getCharacters();
                    break;
                }
                case dataType: {
                    String dtName = this.getCharacters();
                    Datatype.Builtin builtin = Datatype.Builtin.getByDescriptorName(dtName);
                    ((MutableStateVariable)this.getInstance()).dataType = builtin != null ? builtin.getDatatype() : new CustomDatatype(dtName);
                    break;
                }
                case defaultValue: {
                    ((MutableStateVariable)this.getInstance()).defaultValue = this.getCharacters();
                }
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Service.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StateVariableListHandler
    extends ServiceDescriptorHandler<List<MutableStateVariable>> {
        public static final Descriptor.Service.ELEMENT EL = Descriptor.Service.ELEMENT.serviceStateTable;

        public StateVariableListHandler(List<MutableStateVariable> instance, ServiceDescriptorHandler parent) {
            super(instance, parent);
        }

        @Override
        public void startElement(Descriptor.Service.ELEMENT element, Attributes attributes) throws SAXException {
            if (element.equals((Object)StateVariableHandler.EL)) {
                MutableStateVariable stateVariable = new MutableStateVariable();
                String sendEventsAttributeValue = attributes.getValue(Descriptor.Service.ATTRIBUTE.sendEvents.toString());
                stateVariable.eventDetails = new StateVariableEventDetails(sendEventsAttributeValue != null && sendEventsAttributeValue.toUpperCase().equals("YES"));
                ((List)this.getInstance()).add(stateVariable);
                new StateVariableHandler(stateVariable, (ServiceDescriptorHandler)this);
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Service.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ActionArgumentHandler
    extends ServiceDescriptorHandler<MutableActionArgument> {
        public static final Descriptor.Service.ELEMENT EL = Descriptor.Service.ELEMENT.argument;

        public ActionArgumentHandler(MutableActionArgument instance, ServiceDescriptorHandler parent) {
            super(instance, parent);
        }

        @Override
        public void endElement(Descriptor.Service.ELEMENT element) throws SAXException {
            switch (element) {
                case name: {
                    ((MutableActionArgument)this.getInstance()).name = this.getCharacters();
                    break;
                }
                case direction: {
                    ((MutableActionArgument)this.getInstance()).direction = ActionArgument.Direction.valueOf(this.getCharacters().toUpperCase());
                    break;
                }
                case relatedStateVariable: {
                    ((MutableActionArgument)this.getInstance()).relatedStateVariable = this.getCharacters();
                    break;
                }
                case retval: {
                    ((MutableActionArgument)this.getInstance()).retval = true;
                }
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Service.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ActionArgumentListHandler
    extends ServiceDescriptorHandler<List<MutableActionArgument>> {
        public static final Descriptor.Service.ELEMENT EL = Descriptor.Service.ELEMENT.argumentList;

        public ActionArgumentListHandler(List<MutableActionArgument> instance, ServiceDescriptorHandler parent) {
            super(instance, parent);
        }

        @Override
        public void startElement(Descriptor.Service.ELEMENT element, Attributes attributes) throws SAXException {
            if (element.equals((Object)ActionArgumentHandler.EL)) {
                MutableActionArgument argument = new MutableActionArgument();
                ((List)this.getInstance()).add(argument);
                new ActionArgumentHandler(argument, (ServiceDescriptorHandler)this);
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Service.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ActionHandler
    extends ServiceDescriptorHandler<MutableAction> {
        public static final Descriptor.Service.ELEMENT EL = Descriptor.Service.ELEMENT.action;

        public ActionHandler(MutableAction instance, ServiceDescriptorHandler parent) {
            super(instance, parent);
        }

        @Override
        public void startElement(Descriptor.Service.ELEMENT element, Attributes attributes) throws SAXException {
            if (element.equals((Object)ActionArgumentListHandler.EL)) {
                ArrayList<MutableActionArgument> arguments = new ArrayList<MutableActionArgument>();
                ((MutableAction)this.getInstance()).arguments = arguments;
                new ActionArgumentListHandler((List<MutableActionArgument>)arguments, (ServiceDescriptorHandler)this);
            }
        }

        @Override
        public void endElement(Descriptor.Service.ELEMENT element) throws SAXException {
            switch (element) {
                case name: {
                    ((MutableAction)this.getInstance()).name = this.getCharacters();
                }
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Service.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ActionListHandler
    extends ServiceDescriptorHandler<List<MutableAction>> {
        public static final Descriptor.Service.ELEMENT EL = Descriptor.Service.ELEMENT.actionList;

        public ActionListHandler(List<MutableAction> instance, ServiceDescriptorHandler parent) {
            super(instance, parent);
        }

        @Override
        public void startElement(Descriptor.Service.ELEMENT element, Attributes attributes) throws SAXException {
            if (element.equals((Object)ActionHandler.EL)) {
                MutableAction action = new MutableAction();
                ((List)this.getInstance()).add(action);
                new ActionHandler(action, (ServiceDescriptorHandler)this);
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Service.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RootHandler
    extends ServiceDescriptorHandler<MutableService> {
        public RootHandler(MutableService instance, SAXParser parser) {
            super(instance, parser);
        }

        @Override
        public void startElement(Descriptor.Service.ELEMENT element, Attributes attributes) throws SAXException {
            if (element.equals((Object)ActionListHandler.EL)) {
                ArrayList<MutableAction> actions = new ArrayList<MutableAction>();
                ((MutableService)this.getInstance()).actions = actions;
                new ActionListHandler((List<MutableAction>)actions, (ServiceDescriptorHandler)this);
            }
            if (element.equals((Object)StateVariableListHandler.EL)) {
                ArrayList<MutableStateVariable> stateVariables = new ArrayList<MutableStateVariable>();
                ((MutableService)this.getInstance()).stateVariables = stateVariables;
                new StateVariableListHandler((List<MutableStateVariable>)stateVariables, (ServiceDescriptorHandler)this);
            }
        }
    }
}

