/*
 * Decompiled with CFR 0.152.
 */
package org.teleal.cling.binding.xml;

import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.teleal.cling.binding.staging.MutableDevice;
import org.teleal.cling.binding.staging.MutableIcon;
import org.teleal.cling.binding.staging.MutableService;
import org.teleal.cling.binding.xml.Descriptor;
import org.teleal.cling.binding.xml.DescriptorBindingException;
import org.teleal.cling.binding.xml.DeviceDescriptorBinder;
import org.teleal.cling.model.Namespace;
import org.teleal.cling.model.ValidationException;
import org.teleal.cling.model.XMLUtil;
import org.teleal.cling.model.meta.Device;
import org.teleal.cling.model.meta.DeviceDetails;
import org.teleal.cling.model.meta.DeviceIdentity;
import org.teleal.cling.model.meta.Icon;
import org.teleal.cling.model.meta.LocalService;
import org.teleal.cling.model.meta.RemoteService;
import org.teleal.cling.model.meta.Service;
import org.teleal.cling.model.profile.ControlPointInfo;
import org.teleal.cling.model.types.DLNACaps;
import org.teleal.cling.model.types.DLNADoc;
import org.teleal.cling.model.types.InvalidValueException;
import org.teleal.cling.model.types.ServiceId;
import org.teleal.cling.model.types.ServiceType;
import org.teleal.cling.model.types.UDN;
import org.teleal.common.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDA10DeviceDescriptorBinderImpl
implements DeviceDescriptorBinder {
    private static Logger log = Logger.getLogger(DeviceDescriptorBinder.class.getName());

    public <D extends Device> D describe(D undescribedDevice, String descriptorXml) throws DescriptorBindingException, ValidationException {
        if (descriptorXml == null || descriptorXml.length() == 0) {
            throw new DescriptorBindingException("Null or empty descriptor");
        }
        try {
            log.fine("Populating device from XML descriptor: " + undescribedDevice);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document d = factory.newDocumentBuilder().parse(new InputSource(new StringReader(descriptorXml.trim())));
            return this.describe(undescribedDevice, d);
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DescriptorBindingException("Could not parse device descriptor: " + ex.toString(), ex);
        }
    }

    public <D extends Device> D describe(D undescribedDevice, Document dom) throws DescriptorBindingException, ValidationException {
        try {
            log.fine("Populating device from DOM: " + undescribedDevice);
            MutableDevice descriptor = new MutableDevice();
            Element rootElement = dom.getDocumentElement();
            this.hydrateRoot(descriptor, rootElement);
            return this.buildInstance(undescribedDevice, descriptor);
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DescriptorBindingException("Could not parse device DOM: " + ex.toString(), ex);
        }
    }

    public <D extends Device> D buildInstance(D undescribedDevice, MutableDevice descriptor) throws ValidationException {
        return (D)descriptor.build(undescribedDevice);
    }

    protected void hydrateRoot(MutableDevice descriptor, Element rootElement) throws DescriptorBindingException {
        if (rootElement.getNamespaceURI() == null || !rootElement.getNamespaceURI().equals("urn:schemas-upnp-org:device-1-0")) {
            log.warning("Wrong XML namespace declared on root element: " + rootElement.getNamespaceURI());
        }
        if (!rootElement.getNodeName().equals(Descriptor.Device.ELEMENT.root.name())) {
            throw new DescriptorBindingException("Root element name is not <root>: " + rootElement.getNodeName());
        }
        NodeList rootChildren = rootElement.getChildNodes();
        Node deviceNode = null;
        for (int i = 0; i < rootChildren.getLength(); ++i) {
            Node rootChild = rootChildren.item(i);
            if (rootChild.getNodeType() != 1) continue;
            if (Descriptor.Device.ELEMENT.specVersion.equals(rootChild)) {
                this.hydrateSpecVersion(descriptor, rootChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.URLBase.equals(rootChild)) {
                try {
                    descriptor.baseURL = new URL(XMLUtil.getTextContent(rootChild));
                    continue;
                }
                catch (Exception ex) {
                    throw new DescriptorBindingException("Invalid URLBase: " + ex.getMessage());
                }
            }
            if (Descriptor.Device.ELEMENT.device.equals(rootChild)) {
                if (deviceNode != null) {
                    throw new DescriptorBindingException("Found multiple <device> elements in <root>");
                }
                deviceNode = rootChild;
                continue;
            }
            log.finer("Ignoring unknown element: " + rootChild.getNodeName());
        }
        if (deviceNode == null) {
            throw new DescriptorBindingException("No <device> element in <root>");
        }
        this.hydrateDevice(descriptor, deviceNode);
    }

    public void hydrateSpecVersion(MutableDevice descriptor, Node specVersionNode) throws DescriptorBindingException {
        NodeList specVersionChildren = specVersionNode.getChildNodes();
        for (int i = 0; i < specVersionChildren.getLength(); ++i) {
            Node specVersionChild = specVersionChildren.item(i);
            if (specVersionChild.getNodeType() != 1) continue;
            if (Descriptor.Device.ELEMENT.major.equals(specVersionChild)) {
                descriptor.udaVersion.major = Integer.valueOf(XMLUtil.getTextContent(specVersionChild));
                continue;
            }
            if (!Descriptor.Device.ELEMENT.minor.equals(specVersionChild)) continue;
            descriptor.udaVersion.minor = Integer.valueOf(XMLUtil.getTextContent(specVersionChild));
        }
    }

    public void hydrateDevice(MutableDevice descriptor, Node deviceNode) throws DescriptorBindingException {
        NodeList deviceNodeChildren = deviceNode.getChildNodes();
        for (int i = 0; i < deviceNodeChildren.getLength(); ++i) {
            Node deviceNodeChild = deviceNodeChildren.item(i);
            if (deviceNodeChild.getNodeType() != 1) continue;
            if (Descriptor.Device.ELEMENT.deviceType.equals(deviceNodeChild)) {
                descriptor.deviceType = XMLUtil.getTextContent(deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.friendlyName.equals(deviceNodeChild)) {
                descriptor.friendlyName = XMLUtil.getTextContent(deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.manufacturer.equals(deviceNodeChild)) {
                descriptor.manufacturer = XMLUtil.getTextContent(deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.manufacturerURL.equals(deviceNodeChild)) {
                descriptor.manufacturerURI = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(deviceNodeChild));
                continue;
            }
            if (Descriptor.Device.ELEMENT.modelDescription.equals(deviceNodeChild)) {
                descriptor.modelDescription = XMLUtil.getTextContent(deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.modelName.equals(deviceNodeChild)) {
                descriptor.modelName = XMLUtil.getTextContent(deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.modelNumber.equals(deviceNodeChild)) {
                descriptor.modelNumber = XMLUtil.getTextContent(deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.modelURL.equals(deviceNodeChild)) {
                descriptor.modelURI = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(deviceNodeChild));
                continue;
            }
            if (Descriptor.Device.ELEMENT.presentationURL.equals(deviceNodeChild)) {
                descriptor.presentationURI = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(deviceNodeChild));
                continue;
            }
            if (Descriptor.Device.ELEMENT.UPC.equals(deviceNodeChild)) {
                descriptor.upc = XMLUtil.getTextContent(deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.serialNumber.equals(deviceNodeChild)) {
                descriptor.serialNumber = XMLUtil.getTextContent(deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.UDN.equals(deviceNodeChild)) {
                descriptor.udn = UDN.valueOf(XMLUtil.getTextContent(deviceNodeChild));
                continue;
            }
            if (Descriptor.Device.ELEMENT.iconList.equals(deviceNodeChild)) {
                this.hydrateIconList(descriptor, deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.serviceList.equals(deviceNodeChild)) {
                this.hydrateServiceList(descriptor, deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.deviceList.equals(deviceNodeChild)) {
                this.hydrateDeviceList(descriptor, deviceNodeChild);
                continue;
            }
            if (Descriptor.Device.ELEMENT.X_DLNADOC.equals(deviceNodeChild) && "dlna".equals(deviceNodeChild.getPrefix())) {
                String txt = XMLUtil.getTextContent(deviceNodeChild);
                try {
                    descriptor.dlnaDocs.add(DLNADoc.valueOf(txt));
                }
                catch (InvalidValueException ex) {
                    log.info("Invalid X_DLNADOC value, ignoring value: " + txt);
                }
                continue;
            }
            if (!Descriptor.Device.ELEMENT.X_DLNACAP.equals(deviceNodeChild) || !"dlna".equals(deviceNodeChild.getPrefix())) continue;
            descriptor.dlnaCaps = DLNACaps.valueOf(XMLUtil.getTextContent(deviceNodeChild));
        }
    }

    public void hydrateIconList(MutableDevice descriptor, Node iconListNode) throws DescriptorBindingException {
        NodeList iconListNodeChildren = iconListNode.getChildNodes();
        for (int i = 0; i < iconListNodeChildren.getLength(); ++i) {
            Node iconListNodeChild = iconListNodeChildren.item(i);
            if (iconListNodeChild.getNodeType() != 1 || !Descriptor.Device.ELEMENT.icon.equals(iconListNodeChild)) continue;
            MutableIcon icon = new MutableIcon();
            NodeList iconChildren = iconListNodeChild.getChildNodes();
            for (int x = 0; x < iconChildren.getLength(); ++x) {
                Node iconChild = iconChildren.item(x);
                if (iconChild.getNodeType() != 1) continue;
                if (Descriptor.Device.ELEMENT.width.equals(iconChild)) {
                    icon.width = Integer.valueOf(XMLUtil.getTextContent(iconChild));
                    continue;
                }
                if (Descriptor.Device.ELEMENT.height.equals(iconChild)) {
                    icon.height = Integer.valueOf(XMLUtil.getTextContent(iconChild));
                    continue;
                }
                if (Descriptor.Device.ELEMENT.depth.equals(iconChild)) {
                    icon.depth = Integer.valueOf(XMLUtil.getTextContent(iconChild));
                    continue;
                }
                if (Descriptor.Device.ELEMENT.url.equals(iconChild)) {
                    icon.uri = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(iconChild));
                    continue;
                }
                if (!Descriptor.Device.ELEMENT.mimetype.equals(iconChild)) continue;
                icon.mimeType = XMLUtil.getTextContent(iconChild);
            }
            descriptor.icons.add(icon);
        }
    }

    public void hydrateServiceList(MutableDevice descriptor, Node serviceListNode) throws DescriptorBindingException {
        NodeList serviceListNodeChildren = serviceListNode.getChildNodes();
        for (int i = 0; i < serviceListNodeChildren.getLength(); ++i) {
            Node serviceListNodeChild = serviceListNodeChildren.item(i);
            if (serviceListNodeChild.getNodeType() != 1 || !Descriptor.Device.ELEMENT.service.equals(serviceListNodeChild)) continue;
            MutableService service = new MutableService();
            NodeList serviceChildren = serviceListNodeChild.getChildNodes();
            for (int x = 0; x < serviceChildren.getLength(); ++x) {
                Node serviceChild = serviceChildren.item(x);
                if (serviceChild.getNodeType() != 1) continue;
                if (Descriptor.Device.ELEMENT.serviceType.equals(serviceChild)) {
                    service.serviceType = ServiceType.valueOf(XMLUtil.getTextContent(serviceChild));
                    continue;
                }
                if (Descriptor.Device.ELEMENT.serviceId.equals(serviceChild)) {
                    service.serviceId = ServiceId.valueOf(XMLUtil.getTextContent(serviceChild));
                    continue;
                }
                if (Descriptor.Device.ELEMENT.SCPDURL.equals(serviceChild)) {
                    service.descriptorURI = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(serviceChild));
                    continue;
                }
                if (Descriptor.Device.ELEMENT.controlURL.equals(serviceChild)) {
                    service.controlURI = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(serviceChild));
                    continue;
                }
                if (!Descriptor.Device.ELEMENT.eventSubURL.equals(serviceChild)) continue;
                service.eventSubscriptionURI = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(serviceChild));
            }
            descriptor.services.add(service);
        }
    }

    public void hydrateDeviceList(MutableDevice descriptor, Node deviceListNode) throws DescriptorBindingException {
        NodeList deviceListNodeChildren = deviceListNode.getChildNodes();
        for (int i = 0; i < deviceListNodeChildren.getLength(); ++i) {
            Node deviceListNodeChild = deviceListNodeChildren.item(i);
            if (deviceListNodeChild.getNodeType() != 1 || !Descriptor.Device.ELEMENT.device.equals(deviceListNodeChild)) continue;
            MutableDevice embeddedDevice = new MutableDevice();
            embeddedDevice.parentDevice = descriptor;
            descriptor.embeddedDevices.add(embeddedDevice);
            this.hydrateDevice(embeddedDevice, deviceListNodeChild);
        }
    }

    @Override
    public String generate(Device deviceModel, ControlPointInfo info, Namespace namespace) throws DescriptorBindingException {
        try {
            log.fine("Generating XML descriptor from device model: " + deviceModel);
            return XMLUtil.documentToString(this.buildDOM(deviceModel, info, namespace));
        }
        catch (Exception ex) {
            throw new DescriptorBindingException("Could not build DOM: " + ex.getMessage(), ex);
        }
    }

    @Override
    public Document buildDOM(Device deviceModel, ControlPointInfo info, Namespace namespace) throws DescriptorBindingException {
        try {
            log.fine("Generating DOM from device model: " + deviceModel);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document d = factory.newDocumentBuilder().newDocument();
            this.generateRoot(namespace, deviceModel, d, info);
            return d;
        }
        catch (Exception ex) {
            throw new DescriptorBindingException("Could not generate device descriptor: " + ex.getMessage(), ex);
        }
    }

    protected void generateRoot(Namespace namespace, Device deviceModel, Document descriptor, ControlPointInfo info) {
        Element rootElement = descriptor.createElementNS("urn:schemas-upnp-org:device-1-0", Descriptor.Device.ELEMENT.root.toString());
        descriptor.appendChild(rootElement);
        this.generateSpecVersion(namespace, deviceModel, descriptor, rootElement);
        this.generateDevice(namespace, deviceModel, descriptor, rootElement, info);
    }

    protected void generateSpecVersion(Namespace namespace, Device deviceModel, Document descriptor, Element rootElement) {
        Element specVersionElement = XMLUtil.appendNewElement(descriptor, rootElement, Descriptor.Device.ELEMENT.specVersion);
        XMLUtil.appendNewElementIfNotNull(descriptor, specVersionElement, Descriptor.Device.ELEMENT.major, (Object)deviceModel.getVersion().getMajor());
        XMLUtil.appendNewElementIfNotNull(descriptor, specVersionElement, Descriptor.Device.ELEMENT.minor, (Object)deviceModel.getVersion().getMinor());
    }

    protected void generateDevice(Namespace namespace, Device deviceModel, Document descriptor, Element rootElement, ControlPointInfo info) {
        Element deviceElement = XMLUtil.appendNewElement(descriptor, rootElement, Descriptor.Device.ELEMENT.device);
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.deviceType, (Object)deviceModel.getType());
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.UDN, (Object)((DeviceIdentity)deviceModel.getIdentity()).getUdn());
        DeviceDetails deviceModelDetails = deviceModel.getDetails(info);
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.friendlyName, (Object)deviceModelDetails.getFriendlyName());
        if (deviceModelDetails.getManufacturerDetails() != null) {
            XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.manufacturer, (Object)deviceModelDetails.getManufacturerDetails().getManufacturer());
            XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.manufacturerURL, (Object)deviceModelDetails.getManufacturerDetails().getManufacturerURI());
        }
        if (deviceModelDetails.getModelDetails() != null) {
            XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.modelDescription, (Object)deviceModelDetails.getModelDetails().getModelDescription());
            XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.modelName, (Object)deviceModelDetails.getModelDetails().getModelName());
            XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.modelNumber, (Object)deviceModelDetails.getModelDetails().getModelNumber());
            XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.modelURL, (Object)deviceModelDetails.getModelDetails().getModelURI());
        }
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.serialNumber, (Object)deviceModelDetails.getSerialNumber());
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.presentationURL, (Object)deviceModelDetails.getPresentationURI());
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.UPC, (Object)deviceModelDetails.getUpc());
        if (deviceModelDetails.getDlnaDocs() != null) {
            for (DLNADoc dlnaDoc : deviceModelDetails.getDlnaDocs()) {
                XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, "dlna:" + (Object)((Object)Descriptor.Device.ELEMENT.X_DLNADOC), (Object)dlnaDoc, "urn:schemas-dlna-org:device-1-0");
            }
        }
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, "dlna:" + (Object)((Object)Descriptor.Device.ELEMENT.X_DLNACAP), (Object)deviceModelDetails.getDlnaCaps(), "urn:schemas-dlna-org:device-1-0");
        this.generateIconList(namespace, deviceModel, descriptor, deviceElement);
        this.generateServiceList(namespace, deviceModel, descriptor, deviceElement);
        this.generateDeviceList(namespace, deviceModel, descriptor, deviceElement, info);
    }

    protected void generateIconList(Namespace namespace, Device deviceModel, Document descriptor, Element deviceElement) {
        if (!deviceModel.hasIcons()) {
            return;
        }
        Element iconListElement = XMLUtil.appendNewElement(descriptor, deviceElement, Descriptor.Device.ELEMENT.iconList);
        for (Icon icon : deviceModel.getIcons()) {
            Element iconElement = XMLUtil.appendNewElement(descriptor, iconListElement, Descriptor.Device.ELEMENT.icon);
            XMLUtil.appendNewElementIfNotNull(descriptor, iconElement, Descriptor.Device.ELEMENT.mimetype, (Object)icon.getMimeType());
            XMLUtil.appendNewElementIfNotNull(descriptor, iconElement, Descriptor.Device.ELEMENT.width, (Object)icon.getWidth());
            XMLUtil.appendNewElementIfNotNull(descriptor, iconElement, Descriptor.Device.ELEMENT.height, (Object)icon.getHeight());
            XMLUtil.appendNewElementIfNotNull(descriptor, iconElement, Descriptor.Device.ELEMENT.depth, (Object)icon.getDepth());
            XMLUtil.appendNewElementIfNotNull(descriptor, iconElement, Descriptor.Device.ELEMENT.url, (Object)icon.getUri());
        }
    }

    protected void generateServiceList(Namespace namespace, Device deviceModel, Document descriptor, Element deviceElement) {
        if (!deviceModel.hasServices()) {
            return;
        }
        Element serviceListElement = XMLUtil.appendNewElement(descriptor, deviceElement, Descriptor.Device.ELEMENT.serviceList);
        for (Service service : deviceModel.getServices()) {
            Element serviceElement = XMLUtil.appendNewElement(descriptor, serviceListElement, Descriptor.Device.ELEMENT.service);
            XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.serviceType, (Object)service.getServiceType());
            XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.serviceId, (Object)service.getServiceId());
            if (service instanceof RemoteService) {
                RemoteService rs = (RemoteService)service;
                XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.controlURL, (Object)rs.getControlURI());
                XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.eventSubURL, (Object)rs.getEventSubscriptionURI());
                XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.SCPDURL, (Object)rs.getDescriptorURI());
                continue;
            }
            if (!(service instanceof LocalService)) continue;
            LocalService ls = (LocalService)service;
            XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.controlURL, (Object)namespace.getControlPath(ls));
            XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.eventSubURL, (Object)namespace.getEventSubscriptionPath(ls));
            XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.SCPDURL, (Object)namespace.getDescriptorPath(ls));
        }
    }

    protected void generateDeviceList(Namespace namespace, Device deviceModel, Document descriptor, Element deviceElement, ControlPointInfo info) {
        if (!deviceModel.hasEmbeddedDevices()) {
            return;
        }
        Element deviceListElement = XMLUtil.appendNewElement(descriptor, deviceElement, Descriptor.Device.ELEMENT.deviceList);
        for (Device device : deviceModel.getEmbeddedDevices()) {
            this.generateDevice(namespace, device, descriptor, deviceListElement, info);
        }
    }

    protected static URI parseURI(String uri) {
        if (uri.startsWith("www.")) {
            uri = "http://" + uri;
        }
        try {
            return URI.create(uri);
        }
        catch (IllegalArgumentException ex) {
            log.fine("Illegal URI, trying with ./ prefix: " + Exceptions.unwrap(ex));
            try {
                return URI.create("./" + uri);
            }
            catch (IllegalArgumentException ex2) {
                log.warning("Illegal URI '" + uri + "', ignoring value: " + Exceptions.unwrap(ex2));
                return null;
            }
        }
    }
}

